/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CvssScore;
import software.amazon.awssdk.services.inspector2.model.CvssScoreListCopier;
import software.amazon.awssdk.services.inspector2.model.NonEmptyStringListCopier;
import software.amazon.awssdk.services.inspector2.model.VulnerabilityIdListCopier;
import software.amazon.awssdk.services.inspector2.model.VulnerablePackage;
import software.amazon.awssdk.services.inspector2.model.VulnerablePackageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageVulnerabilityDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageVulnerabilityDetails> {
    private static final SdkField<List<CvssScore>> CVSS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cvss").getter(PackageVulnerabilityDetails.getter(PackageVulnerabilityDetails::cvss)).setter(PackageVulnerabilityDetails.setter(Builder::cvss)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cvss").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CvssScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REFERENCE_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("referenceUrls").getter(PackageVulnerabilityDetails.getter(PackageVulnerabilityDetails::referenceUrls)).setter(PackageVulnerabilityDetails.setter(Builder::referenceUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RELATED_VULNERABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relatedVulnerabilities").getter(PackageVulnerabilityDetails.getter(PackageVulnerabilityDetails::relatedVulnerabilities)).setter(PackageVulnerabilityDetails.setter(Builder::relatedVulnerabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedVulnerabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(PackageVulnerabilityDetails.getter(PackageVulnerabilityDetails::source)).setter(PackageVulnerabilityDetails.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceUrl").getter(PackageVulnerabilityDetails.getter(PackageVulnerabilityDetails::sourceUrl)).setter(PackageVulnerabilityDetails.setter(Builder::sourceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceUrl").build()}).build();
    private static final SdkField<Instant> VENDOR_CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("vendorCreatedAt").getter(PackageVulnerabilityDetails.getter(PackageVulnerabilityDetails::vendorCreatedAt)).setter(PackageVulnerabilityDetails.setter(Builder::vendorCreatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorCreatedAt").build()}).build();
    private static final SdkField<String> VENDOR_SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vendorSeverity").getter(PackageVulnerabilityDetails.getter(PackageVulnerabilityDetails::vendorSeverity)).setter(PackageVulnerabilityDetails.setter(Builder::vendorSeverity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorSeverity").build()}).build();
    private static final SdkField<Instant> VENDOR_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("vendorUpdatedAt").getter(PackageVulnerabilityDetails.getter(PackageVulnerabilityDetails::vendorUpdatedAt)).setter(PackageVulnerabilityDetails.setter(Builder::vendorUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorUpdatedAt").build()}).build();
    private static final SdkField<String> VULNERABILITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vulnerabilityId").getter(PackageVulnerabilityDetails.getter(PackageVulnerabilityDetails::vulnerabilityId)).setter(PackageVulnerabilityDetails.setter(Builder::vulnerabilityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilityId").build()}).build();
    private static final SdkField<List<VulnerablePackage>> VULNERABLE_PACKAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vulnerablePackages").getter(PackageVulnerabilityDetails.getter(PackageVulnerabilityDetails::vulnerablePackages)).setter(PackageVulnerabilityDetails.setter(Builder::vulnerablePackages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerablePackages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VulnerablePackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CVSS_FIELD, REFERENCE_URLS_FIELD, RELATED_VULNERABILITIES_FIELD, SOURCE_FIELD, SOURCE_URL_FIELD, VENDOR_CREATED_AT_FIELD, VENDOR_SEVERITY_FIELD, VENDOR_UPDATED_AT_FIELD, VULNERABILITY_ID_FIELD, VULNERABLE_PACKAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cvss", CVSS_FIELD);
            this.put("referenceUrls", REFERENCE_URLS_FIELD);
            this.put("relatedVulnerabilities", RELATED_VULNERABILITIES_FIELD);
            this.put("source", SOURCE_FIELD);
            this.put("sourceUrl", SOURCE_URL_FIELD);
            this.put("vendorCreatedAt", VENDOR_CREATED_AT_FIELD);
            this.put("vendorSeverity", VENDOR_SEVERITY_FIELD);
            this.put("vendorUpdatedAt", VENDOR_UPDATED_AT_FIELD);
            this.put("vulnerabilityId", VULNERABILITY_ID_FIELD);
            this.put("vulnerablePackages", VULNERABLE_PACKAGES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<CvssScore> cvss;
    private final List<String> referenceUrls;
    private final List<String> relatedVulnerabilities;
    private final String source;
    private final String sourceUrl;
    private final Instant vendorCreatedAt;
    private final String vendorSeverity;
    private final Instant vendorUpdatedAt;
    private final String vulnerabilityId;
    private final List<VulnerablePackage> vulnerablePackages;

    private PackageVulnerabilityDetails(BuilderImpl builder) {
        this.cvss = builder.cvss;
        this.referenceUrls = builder.referenceUrls;
        this.relatedVulnerabilities = builder.relatedVulnerabilities;
        this.source = builder.source;
        this.sourceUrl = builder.sourceUrl;
        this.vendorCreatedAt = builder.vendorCreatedAt;
        this.vendorSeverity = builder.vendorSeverity;
        this.vendorUpdatedAt = builder.vendorUpdatedAt;
        this.vulnerabilityId = builder.vulnerabilityId;
        this.vulnerablePackages = builder.vulnerablePackages;
    }

    public final boolean hasCvss() {
        return this.cvss != null && !(this.cvss instanceof SdkAutoConstructList);
    }

    public final List<CvssScore> cvss() {
        return this.cvss;
    }

    public final boolean hasReferenceUrls() {
        return this.referenceUrls != null && !(this.referenceUrls instanceof SdkAutoConstructList);
    }

    public final List<String> referenceUrls() {
        return this.referenceUrls;
    }

    public final boolean hasRelatedVulnerabilities() {
        return this.relatedVulnerabilities != null && !(this.relatedVulnerabilities instanceof SdkAutoConstructList);
    }

    public final List<String> relatedVulnerabilities() {
        return this.relatedVulnerabilities;
    }

    public final String source() {
        return this.source;
    }

    public final String sourceUrl() {
        return this.sourceUrl;
    }

    public final Instant vendorCreatedAt() {
        return this.vendorCreatedAt;
    }

    public final String vendorSeverity() {
        return this.vendorSeverity;
    }

    public final Instant vendorUpdatedAt() {
        return this.vendorUpdatedAt;
    }

    public final String vulnerabilityId() {
        return this.vulnerabilityId;
    }

    public final boolean hasVulnerablePackages() {
        return this.vulnerablePackages != null && !(this.vulnerablePackages instanceof SdkAutoConstructList);
    }

    public final List<VulnerablePackage> vulnerablePackages() {
        return this.vulnerablePackages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCvss() ? this.cvss() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceUrls() ? this.referenceUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedVulnerabilities() ? this.relatedVulnerabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorSeverity());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.vulnerabilityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVulnerablePackages() ? this.vulnerablePackages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageVulnerabilityDetails)) {
            return false;
        }
        PackageVulnerabilityDetails other = (PackageVulnerabilityDetails)obj;
        return this.hasCvss() == other.hasCvss() && Objects.equals(this.cvss(), other.cvss()) && this.hasReferenceUrls() == other.hasReferenceUrls() && Objects.equals(this.referenceUrls(), other.referenceUrls()) && this.hasRelatedVulnerabilities() == other.hasRelatedVulnerabilities() && Objects.equals(this.relatedVulnerabilities(), other.relatedVulnerabilities()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.sourceUrl(), other.sourceUrl()) && Objects.equals(this.vendorCreatedAt(), other.vendorCreatedAt()) && Objects.equals(this.vendorSeverity(), other.vendorSeverity()) && Objects.equals(this.vendorUpdatedAt(), other.vendorUpdatedAt()) && Objects.equals(this.vulnerabilityId(), other.vulnerabilityId()) && this.hasVulnerablePackages() == other.hasVulnerablePackages() && Objects.equals(this.vulnerablePackages(), other.vulnerablePackages());
    }

    public final String toString() {
        return ToString.builder((String)"PackageVulnerabilityDetails").add("Cvss", this.hasCvss() ? this.cvss() : null).add("ReferenceUrls", this.hasReferenceUrls() ? this.referenceUrls() : null).add("RelatedVulnerabilities", this.hasRelatedVulnerabilities() ? this.relatedVulnerabilities() : null).add("Source", (Object)this.source()).add("SourceUrl", (Object)this.sourceUrl()).add("VendorCreatedAt", (Object)this.vendorCreatedAt()).add("VendorSeverity", (Object)this.vendorSeverity()).add("VendorUpdatedAt", (Object)this.vendorUpdatedAt()).add("VulnerabilityId", (Object)this.vulnerabilityId()).add("VulnerablePackages", this.hasVulnerablePackages() ? this.vulnerablePackages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cvss": {
                return Optional.ofNullable(clazz.cast(this.cvss()));
            }
            case "referenceUrls": {
                return Optional.ofNullable(clazz.cast(this.referenceUrls()));
            }
            case "relatedVulnerabilities": {
                return Optional.ofNullable(clazz.cast(this.relatedVulnerabilities()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "sourceUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceUrl()));
            }
            case "vendorCreatedAt": {
                return Optional.ofNullable(clazz.cast(this.vendorCreatedAt()));
            }
            case "vendorSeverity": {
                return Optional.ofNullable(clazz.cast(this.vendorSeverity()));
            }
            case "vendorUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.vendorUpdatedAt()));
            }
            case "vulnerabilityId": {
                return Optional.ofNullable(clazz.cast(this.vulnerabilityId()));
            }
            case "vulnerablePackages": {
                return Optional.ofNullable(clazz.cast(this.vulnerablePackages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PackageVulnerabilityDetails, T> g) {
        return obj -> g.apply((PackageVulnerabilityDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CvssScore> cvss = DefaultSdkAutoConstructList.getInstance();
        private List<String> referenceUrls = DefaultSdkAutoConstructList.getInstance();
        private List<String> relatedVulnerabilities = DefaultSdkAutoConstructList.getInstance();
        private String source;
        private String sourceUrl;
        private Instant vendorCreatedAt;
        private String vendorSeverity;
        private Instant vendorUpdatedAt;
        private String vulnerabilityId;
        private List<VulnerablePackage> vulnerablePackages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PackageVulnerabilityDetails model) {
            this.cvss(model.cvss);
            this.referenceUrls(model.referenceUrls);
            this.relatedVulnerabilities(model.relatedVulnerabilities);
            this.source(model.source);
            this.sourceUrl(model.sourceUrl);
            this.vendorCreatedAt(model.vendorCreatedAt);
            this.vendorSeverity(model.vendorSeverity);
            this.vendorUpdatedAt(model.vendorUpdatedAt);
            this.vulnerabilityId(model.vulnerabilityId);
            this.vulnerablePackages(model.vulnerablePackages);
        }

        public final List<CvssScore.Builder> getCvss() {
            List<CvssScore.Builder> result = CvssScoreListCopier.copyToBuilder(this.cvss);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCvss(Collection<CvssScore.BuilderImpl> cvss) {
            this.cvss = CvssScoreListCopier.copyFromBuilder(cvss);
        }

        @Override
        public final Builder cvss(Collection<CvssScore> cvss) {
            this.cvss = CvssScoreListCopier.copy(cvss);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cvss(CvssScore ... cvss) {
            this.cvss(Arrays.asList(cvss));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cvss(Consumer<CvssScore.Builder> ... cvss) {
            this.cvss(Stream.of(cvss).map(c -> (CvssScore)((CvssScore.Builder)CvssScore.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getReferenceUrls() {
            if (this.referenceUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.referenceUrls;
        }

        public final void setReferenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = NonEmptyStringListCopier.copy(referenceUrls);
        }

        @Override
        public final Builder referenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = NonEmptyStringListCopier.copy(referenceUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceUrls(String ... referenceUrls) {
            this.referenceUrls(Arrays.asList(referenceUrls));
            return this;
        }

        public final Collection<String> getRelatedVulnerabilities() {
            if (this.relatedVulnerabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.relatedVulnerabilities;
        }

        public final void setRelatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = VulnerabilityIdListCopier.copy(relatedVulnerabilities);
        }

        @Override
        public final Builder relatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = VulnerabilityIdListCopier.copy(relatedVulnerabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedVulnerabilities(String ... relatedVulnerabilities) {
            this.relatedVulnerabilities(Arrays.asList(relatedVulnerabilities));
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getSourceUrl() {
            return this.sourceUrl;
        }

        public final void setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
        }

        @Override
        public final Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public final Instant getVendorCreatedAt() {
            return this.vendorCreatedAt;
        }

        public final void setVendorCreatedAt(Instant vendorCreatedAt) {
            this.vendorCreatedAt = vendorCreatedAt;
        }

        @Override
        public final Builder vendorCreatedAt(Instant vendorCreatedAt) {
            this.vendorCreatedAt = vendorCreatedAt;
            return this;
        }

        public final String getVendorSeverity() {
            return this.vendorSeverity;
        }

        public final void setVendorSeverity(String vendorSeverity) {
            this.vendorSeverity = vendorSeverity;
        }

        @Override
        public final Builder vendorSeverity(String vendorSeverity) {
            this.vendorSeverity = vendorSeverity;
            return this;
        }

        public final Instant getVendorUpdatedAt() {
            return this.vendorUpdatedAt;
        }

        public final void setVendorUpdatedAt(Instant vendorUpdatedAt) {
            this.vendorUpdatedAt = vendorUpdatedAt;
        }

        @Override
        public final Builder vendorUpdatedAt(Instant vendorUpdatedAt) {
            this.vendorUpdatedAt = vendorUpdatedAt;
            return this;
        }

        public final String getVulnerabilityId() {
            return this.vulnerabilityId;
        }

        public final void setVulnerabilityId(String vulnerabilityId) {
            this.vulnerabilityId = vulnerabilityId;
        }

        @Override
        public final Builder vulnerabilityId(String vulnerabilityId) {
            this.vulnerabilityId = vulnerabilityId;
            return this;
        }

        public final List<VulnerablePackage.Builder> getVulnerablePackages() {
            List<VulnerablePackage.Builder> result = VulnerablePackageListCopier.copyToBuilder(this.vulnerablePackages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVulnerablePackages(Collection<VulnerablePackage.BuilderImpl> vulnerablePackages) {
            this.vulnerablePackages = VulnerablePackageListCopier.copyFromBuilder(vulnerablePackages);
        }

        @Override
        public final Builder vulnerablePackages(Collection<VulnerablePackage> vulnerablePackages) {
            this.vulnerablePackages = VulnerablePackageListCopier.copy(vulnerablePackages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerablePackages(VulnerablePackage ... vulnerablePackages) {
            this.vulnerablePackages(Arrays.asList(vulnerablePackages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerablePackages(Consumer<VulnerablePackage.Builder> ... vulnerablePackages) {
            this.vulnerablePackages(Stream.of(vulnerablePackages).map(c -> (VulnerablePackage)((VulnerablePackage.Builder)VulnerablePackage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PackageVulnerabilityDetails build() {
            return new PackageVulnerabilityDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageVulnerabilityDetails> {
        public Builder cvss(Collection<CvssScore> var1);

        public Builder cvss(CvssScore ... var1);

        public Builder cvss(Consumer<CvssScore.Builder> ... var1);

        public Builder referenceUrls(Collection<String> var1);

        public Builder referenceUrls(String ... var1);

        public Builder relatedVulnerabilities(Collection<String> var1);

        public Builder relatedVulnerabilities(String ... var1);

        public Builder source(String var1);

        public Builder sourceUrl(String var1);

        public Builder vendorCreatedAt(Instant var1);

        public Builder vendorSeverity(String var1);

        public Builder vendorUpdatedAt(Instant var1);

        public Builder vulnerabilityId(String var1);

        public Builder vulnerablePackages(Collection<VulnerablePackage> var1);

        public Builder vulnerablePackages(VulnerablePackage ... var1);

        public Builder vulnerablePackages(Consumer<VulnerablePackage.Builder> ... var1);
    }
}

