/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cvss3
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cvss3> {
    private static final SdkField<Double> BASE_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("baseScore").getter(Cvss3.getter(Cvss3::baseScore)).setter(Cvss3.setter(Builder::baseScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseScore").build()}).build();
    private static final SdkField<String> SCORING_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scoringVector").getter(Cvss3.getter(Cvss3::scoringVector)).setter(Cvss3.setter(Builder::scoringVector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scoringVector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_SCORE_FIELD, SCORING_VECTOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("baseScore", BASE_SCORE_FIELD);
            this.put("scoringVector", SCORING_VECTOR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Double baseScore;
    private final String scoringVector;

    private Cvss3(BuilderImpl builder) {
        this.baseScore = builder.baseScore;
        this.scoringVector = builder.scoringVector;
    }

    public final Double baseScore() {
        return this.baseScore;
    }

    public final String scoringVector() {
        return this.scoringVector;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.scoringVector());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cvss3)) {
            return false;
        }
        Cvss3 other = (Cvss3)obj;
        return Objects.equals(this.baseScore(), other.baseScore()) && Objects.equals(this.scoringVector(), other.scoringVector());
    }

    public final String toString() {
        return ToString.builder((String)"Cvss3").add("BaseScore", (Object)this.baseScore()).add("ScoringVector", (Object)this.scoringVector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "baseScore": {
                return Optional.ofNullable(clazz.cast(this.baseScore()));
            }
            case "scoringVector": {
                return Optional.ofNullable(clazz.cast(this.scoringVector()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Cvss3, T> g) {
        return obj -> g.apply((Cvss3)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double baseScore;
        private String scoringVector;

        private BuilderImpl() {
        }

        private BuilderImpl(Cvss3 model) {
            this.baseScore(model.baseScore);
            this.scoringVector(model.scoringVector);
        }

        public final Double getBaseScore() {
            return this.baseScore;
        }

        public final void setBaseScore(Double baseScore) {
            this.baseScore = baseScore;
        }

        @Override
        public final Builder baseScore(Double baseScore) {
            this.baseScore = baseScore;
            return this;
        }

        public final String getScoringVector() {
            return this.scoringVector;
        }

        public final void setScoringVector(String scoringVector) {
            this.scoringVector = scoringVector;
        }

        @Override
        public final Builder scoringVector(String scoringVector) {
            this.scoringVector = scoringVector;
            return this;
        }

        public Cvss3 build() {
            return new Cvss3(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cvss3> {
        public Builder baseScore(Double var1);

        public Builder scoringVector(String var1);
    }
}

