/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CisScanConfigurationArnFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CisScanNameFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.CisStringFilter;
import software.amazon.awssdk.services.inspector2.model.ResourceTagFilterListCopier;
import software.amazon.awssdk.services.inspector2.model.TagFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCisScanConfigurationsFilterCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListCisScanConfigurationsFilterCriteria> {
    private static final SdkField<List<CisStringFilter>> SCAN_CONFIGURATION_ARN_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scanConfigurationArnFilters").getter(ListCisScanConfigurationsFilterCriteria.getter(ListCisScanConfigurationsFilterCriteria::scanConfigurationArnFilters)).setter(ListCisScanConfigurationsFilterCriteria.setter(Builder::scanConfigurationArnFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArnFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CisStringFilter>> SCAN_NAME_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scanNameFilters").getter(ListCisScanConfigurationsFilterCriteria.getter(ListCisScanConfigurationsFilterCriteria::scanNameFilters)).setter(ListCisScanConfigurationsFilterCriteria.setter(Builder::scanNameFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanNameFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CisStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TagFilter>> TARGET_RESOURCE_TAG_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetResourceTagFilters").getter(ListCisScanConfigurationsFilterCriteria.getter(ListCisScanConfigurationsFilterCriteria::targetResourceTagFilters)).setter(ListCisScanConfigurationsFilterCriteria.setter(Builder::targetResourceTagFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceTagFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_CONFIGURATION_ARN_FILTERS_FIELD, SCAN_NAME_FILTERS_FIELD, TARGET_RESOURCE_TAG_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCisScanConfigurationsFilterCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<CisStringFilter> scanConfigurationArnFilters;
    private final List<CisStringFilter> scanNameFilters;
    private final List<TagFilter> targetResourceTagFilters;

    private ListCisScanConfigurationsFilterCriteria(BuilderImpl builder) {
        this.scanConfigurationArnFilters = builder.scanConfigurationArnFilters;
        this.scanNameFilters = builder.scanNameFilters;
        this.targetResourceTagFilters = builder.targetResourceTagFilters;
    }

    public final boolean hasScanConfigurationArnFilters() {
        return this.scanConfigurationArnFilters != null && !(this.scanConfigurationArnFilters instanceof SdkAutoConstructList);
    }

    public final List<CisStringFilter> scanConfigurationArnFilters() {
        return this.scanConfigurationArnFilters;
    }

    public final boolean hasScanNameFilters() {
        return this.scanNameFilters != null && !(this.scanNameFilters instanceof SdkAutoConstructList);
    }

    public final List<CisStringFilter> scanNameFilters() {
        return this.scanNameFilters;
    }

    public final boolean hasTargetResourceTagFilters() {
        return this.targetResourceTagFilters != null && !(this.targetResourceTagFilters instanceof SdkAutoConstructList);
    }

    public final List<TagFilter> targetResourceTagFilters() {
        return this.targetResourceTagFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanConfigurationArnFilters() ? this.scanConfigurationArnFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanNameFilters() ? this.scanNameFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetResourceTagFilters() ? this.targetResourceTagFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCisScanConfigurationsFilterCriteria)) {
            return false;
        }
        ListCisScanConfigurationsFilterCriteria other = (ListCisScanConfigurationsFilterCriteria)obj;
        return this.hasScanConfigurationArnFilters() == other.hasScanConfigurationArnFilters() && Objects.equals(this.scanConfigurationArnFilters(), other.scanConfigurationArnFilters()) && this.hasScanNameFilters() == other.hasScanNameFilters() && Objects.equals(this.scanNameFilters(), other.scanNameFilters()) && this.hasTargetResourceTagFilters() == other.hasTargetResourceTagFilters() && Objects.equals(this.targetResourceTagFilters(), other.targetResourceTagFilters());
    }

    public final String toString() {
        return ToString.builder((String)"ListCisScanConfigurationsFilterCriteria").add("ScanConfigurationArnFilters", this.hasScanConfigurationArnFilters() ? this.scanConfigurationArnFilters() : null).add("ScanNameFilters", this.hasScanNameFilters() ? this.scanNameFilters() : null).add("TargetResourceTagFilters", this.hasTargetResourceTagFilters() ? this.targetResourceTagFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scanConfigurationArnFilters": {
                return Optional.ofNullable(clazz.cast(this.scanConfigurationArnFilters()));
            }
            case "scanNameFilters": {
                return Optional.ofNullable(clazz.cast(this.scanNameFilters()));
            }
            case "targetResourceTagFilters": {
                return Optional.ofNullable(clazz.cast(this.targetResourceTagFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scanConfigurationArnFilters", SCAN_CONFIGURATION_ARN_FILTERS_FIELD);
        map.put("scanNameFilters", SCAN_NAME_FILTERS_FIELD);
        map.put("targetResourceTagFilters", TARGET_RESOURCE_TAG_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCisScanConfigurationsFilterCriteria, T> g) {
        return obj -> g.apply((ListCisScanConfigurationsFilterCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CisStringFilter> scanConfigurationArnFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CisStringFilter> scanNameFilters = DefaultSdkAutoConstructList.getInstance();
        private List<TagFilter> targetResourceTagFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCisScanConfigurationsFilterCriteria model) {
            this.scanConfigurationArnFilters(model.scanConfigurationArnFilters);
            this.scanNameFilters(model.scanNameFilters);
            this.targetResourceTagFilters(model.targetResourceTagFilters);
        }

        public final List<CisStringFilter.Builder> getScanConfigurationArnFilters() {
            List<CisStringFilter.Builder> result = CisScanConfigurationArnFilterListCopier.copyToBuilder(this.scanConfigurationArnFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanConfigurationArnFilters(Collection<CisStringFilter.BuilderImpl> scanConfigurationArnFilters) {
            this.scanConfigurationArnFilters = CisScanConfigurationArnFilterListCopier.copyFromBuilder(scanConfigurationArnFilters);
        }

        @Override
        public final Builder scanConfigurationArnFilters(Collection<CisStringFilter> scanConfigurationArnFilters) {
            this.scanConfigurationArnFilters = CisScanConfigurationArnFilterListCopier.copy(scanConfigurationArnFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanConfigurationArnFilters(CisStringFilter ... scanConfigurationArnFilters) {
            this.scanConfigurationArnFilters(Arrays.asList(scanConfigurationArnFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanConfigurationArnFilters(Consumer<CisStringFilter.Builder> ... scanConfigurationArnFilters) {
            this.scanConfigurationArnFilters(Stream.of(scanConfigurationArnFilters).map(c -> (CisStringFilter)((CisStringFilter.Builder)CisStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getScanNameFilters() {
            List<CisStringFilter.Builder> result = CisScanNameFilterListCopier.copyToBuilder(this.scanNameFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanNameFilters(Collection<CisStringFilter.BuilderImpl> scanNameFilters) {
            this.scanNameFilters = CisScanNameFilterListCopier.copyFromBuilder(scanNameFilters);
        }

        @Override
        public final Builder scanNameFilters(Collection<CisStringFilter> scanNameFilters) {
            this.scanNameFilters = CisScanNameFilterListCopier.copy(scanNameFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanNameFilters(CisStringFilter ... scanNameFilters) {
            this.scanNameFilters(Arrays.asList(scanNameFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanNameFilters(Consumer<CisStringFilter.Builder> ... scanNameFilters) {
            this.scanNameFilters(Stream.of(scanNameFilters).map(c -> (CisStringFilter)((CisStringFilter.Builder)CisStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TagFilter.Builder> getTargetResourceTagFilters() {
            List<TagFilter.Builder> result = ResourceTagFilterListCopier.copyToBuilder(this.targetResourceTagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetResourceTagFilters(Collection<TagFilter.BuilderImpl> targetResourceTagFilters) {
            this.targetResourceTagFilters = ResourceTagFilterListCopier.copyFromBuilder(targetResourceTagFilters);
        }

        @Override
        public final Builder targetResourceTagFilters(Collection<TagFilter> targetResourceTagFilters) {
            this.targetResourceTagFilters = ResourceTagFilterListCopier.copy(targetResourceTagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceTagFilters(TagFilter ... targetResourceTagFilters) {
            this.targetResourceTagFilters(Arrays.asList(targetResourceTagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceTagFilters(Consumer<TagFilter.Builder> ... targetResourceTagFilters) {
            this.targetResourceTagFilters(Stream.of(targetResourceTagFilters).map(c -> (TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ListCisScanConfigurationsFilterCriteria build() {
            return new ListCisScanConfigurationsFilterCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListCisScanConfigurationsFilterCriteria> {
        public Builder scanConfigurationArnFilters(Collection<CisStringFilter> var1);

        public Builder scanConfigurationArnFilters(CisStringFilter ... var1);

        public Builder scanConfigurationArnFilters(Consumer<CisStringFilter.Builder> ... var1);

        public Builder scanNameFilters(Collection<CisStringFilter> var1);

        public Builder scanNameFilters(CisStringFilter ... var1);

        public Builder scanNameFilters(Consumer<CisStringFilter.Builder> ... var1);

        public Builder targetResourceTagFilters(Collection<TagFilter> var1);

        public Builder targetResourceTagFilters(TagFilter ... var1);

        public Builder targetResourceTagFilters(Consumer<TagFilter.Builder> ... var1);
    }
}

