/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector.model.AgentHealth;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentPreview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentPreview> {
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostname").getter(AgentPreview.getter(AgentPreview::hostname)).setter(AgentPreview.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(AgentPreview.getter(AgentPreview::agentId)).setter(AgentPreview.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoScalingGroup").getter(AgentPreview.getter(AgentPreview::autoScalingGroup)).setter(AgentPreview.setter(Builder::autoScalingGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroup").build()}).build();
    private static final SdkField<String> AGENT_HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentHealth").getter(AgentPreview.getter(AgentPreview::agentHealthAsString)).setter(AgentPreview.setter(Builder::agentHealth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentHealth").build()}).build();
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentVersion").getter(AgentPreview.getter(AgentPreview::agentVersion)).setter(AgentPreview.setter(Builder::agentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operatingSystem").getter(AgentPreview.getter(AgentPreview::operatingSystem)).setter(AgentPreview.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystem").build()}).build();
    private static final SdkField<String> KERNEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kernelVersion").getter(AgentPreview.getter(AgentPreview::kernelVersion)).setter(AgentPreview.setter(Builder::kernelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kernelVersion").build()}).build();
    private static final SdkField<String> IPV4_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipv4Address").getter(AgentPreview.getter(AgentPreview::ipv4Address)).setter(AgentPreview.setter(Builder::ipv4Address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv4Address").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_FIELD, AGENT_ID_FIELD, AUTO_SCALING_GROUP_FIELD, AGENT_HEALTH_FIELD, AGENT_VERSION_FIELD, OPERATING_SYSTEM_FIELD, KERNEL_VERSION_FIELD, IPV4_ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AgentPreview.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hostname;
    private final String agentId;
    private final String autoScalingGroup;
    private final String agentHealth;
    private final String agentVersion;
    private final String operatingSystem;
    private final String kernelVersion;
    private final String ipv4Address;

    private AgentPreview(BuilderImpl builder) {
        this.hostname = builder.hostname;
        this.agentId = builder.agentId;
        this.autoScalingGroup = builder.autoScalingGroup;
        this.agentHealth = builder.agentHealth;
        this.agentVersion = builder.agentVersion;
        this.operatingSystem = builder.operatingSystem;
        this.kernelVersion = builder.kernelVersion;
        this.ipv4Address = builder.ipv4Address;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String autoScalingGroup() {
        return this.autoScalingGroup;
    }

    public final AgentHealth agentHealth() {
        return AgentHealth.fromValue(this.agentHealth);
    }

    public final String agentHealthAsString() {
        return this.agentHealth;
    }

    public final String agentVersion() {
        return this.agentVersion;
    }

    public final String operatingSystem() {
        return this.operatingSystem;
    }

    public final String kernelVersion() {
        return this.kernelVersion;
    }

    public final String ipv4Address() {
        return this.ipv4Address;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentHealthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystem());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4Address());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentPreview)) {
            return false;
        }
        AgentPreview other = (AgentPreview)obj;
        return Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.autoScalingGroup(), other.autoScalingGroup()) && Objects.equals(this.agentHealthAsString(), other.agentHealthAsString()) && Objects.equals(this.agentVersion(), other.agentVersion()) && Objects.equals(this.operatingSystem(), other.operatingSystem()) && Objects.equals(this.kernelVersion(), other.kernelVersion()) && Objects.equals(this.ipv4Address(), other.ipv4Address());
    }

    public final String toString() {
        return ToString.builder((String)"AgentPreview").add("Hostname", (Object)this.hostname()).add("AgentId", (Object)this.agentId()).add("AutoScalingGroup", (Object)this.autoScalingGroup()).add("AgentHealth", (Object)this.agentHealthAsString()).add("AgentVersion", (Object)this.agentVersion()).add("OperatingSystem", (Object)this.operatingSystem()).add("KernelVersion", (Object)this.kernelVersion()).add("Ipv4Address", (Object)this.ipv4Address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "autoScalingGroup": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroup()));
            }
            case "agentHealth": {
                return Optional.ofNullable(clazz.cast(this.agentHealthAsString()));
            }
            case "agentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
            case "operatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystem()));
            }
            case "kernelVersion": {
                return Optional.ofNullable(clazz.cast(this.kernelVersion()));
            }
            case "ipv4Address": {
                return Optional.ofNullable(clazz.cast(this.ipv4Address()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("hostname", HOSTNAME_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("autoScalingGroup", AUTO_SCALING_GROUP_FIELD);
        map.put("agentHealth", AGENT_HEALTH_FIELD);
        map.put("agentVersion", AGENT_VERSION_FIELD);
        map.put("operatingSystem", OPERATING_SYSTEM_FIELD);
        map.put("kernelVersion", KERNEL_VERSION_FIELD);
        map.put("ipv4Address", IPV4_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentPreview, T> g) {
        return obj -> g.apply((AgentPreview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostname;
        private String agentId;
        private String autoScalingGroup;
        private String agentHealth;
        private String agentVersion;
        private String operatingSystem;
        private String kernelVersion;
        private String ipv4Address;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentPreview model) {
            this.hostname(model.hostname);
            this.agentId(model.agentId);
            this.autoScalingGroup(model.autoScalingGroup);
            this.agentHealth(model.agentHealth);
            this.agentVersion(model.agentVersion);
            this.operatingSystem(model.operatingSystem);
            this.kernelVersion(model.kernelVersion);
            this.ipv4Address(model.ipv4Address);
        }

        public final String getHostname() {
            return this.hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAutoScalingGroup() {
            return this.autoScalingGroup;
        }

        public final void setAutoScalingGroup(String autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
        }

        @Override
        public final Builder autoScalingGroup(String autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
            return this;
        }

        public final String getAgentHealth() {
            return this.agentHealth;
        }

        public final void setAgentHealth(String agentHealth) {
            this.agentHealth = agentHealth;
        }

        @Override
        public final Builder agentHealth(String agentHealth) {
            this.agentHealth = agentHealth;
            return this;
        }

        @Override
        public final Builder agentHealth(AgentHealth agentHealth) {
            this.agentHealth(agentHealth == null ? null : agentHealth.toString());
            return this;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public final String getKernelVersion() {
            return this.kernelVersion;
        }

        public final void setKernelVersion(String kernelVersion) {
            this.kernelVersion = kernelVersion;
        }

        @Override
        public final Builder kernelVersion(String kernelVersion) {
            this.kernelVersion = kernelVersion;
            return this;
        }

        public final String getIpv4Address() {
            return this.ipv4Address;
        }

        public final void setIpv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
        }

        @Override
        public final Builder ipv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
            return this;
        }

        public AgentPreview build() {
            return new AgentPreview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentPreview> {
        public Builder hostname(String var1);

        public Builder agentId(String var1);

        public Builder autoScalingGroup(String var1);

        public Builder agentHealth(String var1);

        public Builder agentHealth(AgentHealth var1);

        public Builder agentVersion(String var1);

        public Builder operatingSystem(String var1);

        public Builder kernelVersion(String var1);

        public Builder ipv4Address(String var1);
    }
}

