/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InspectorServiceAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InspectorServiceAttributes> {
    private static final SdkField<Integer> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("schemaVersion").getter(InspectorServiceAttributes.getter(InspectorServiceAttributes::schemaVersion)).setter(InspectorServiceAttributes.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()}).build();
    private static final SdkField<String> ASSESSMENT_RUN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentRunArn").getter(InspectorServiceAttributes.getter(InspectorServiceAttributes::assessmentRunArn)).setter(InspectorServiceAttributes.setter(Builder::assessmentRunArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArn").build()}).build();
    private static final SdkField<String> RULES_PACKAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rulesPackageArn").getter(InspectorServiceAttributes.getter(InspectorServiceAttributes::rulesPackageArn)).setter(InspectorServiceAttributes.setter(Builder::rulesPackageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackageArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_FIELD, ASSESSMENT_RUN_ARN_FIELD, RULES_PACKAGE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("schemaVersion", SCHEMA_VERSION_FIELD);
            this.put("assessmentRunArn", ASSESSMENT_RUN_ARN_FIELD);
            this.put("rulesPackageArn", RULES_PACKAGE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer schemaVersion;
    private final String assessmentRunArn;
    private final String rulesPackageArn;

    private InspectorServiceAttributes(BuilderImpl builder) {
        this.schemaVersion = builder.schemaVersion;
        this.assessmentRunArn = builder.assessmentRunArn;
        this.rulesPackageArn = builder.rulesPackageArn;
    }

    public final Integer schemaVersion() {
        return this.schemaVersion;
    }

    public final String assessmentRunArn() {
        return this.assessmentRunArn;
    }

    public final String rulesPackageArn() {
        return this.rulesPackageArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.rulesPackageArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InspectorServiceAttributes)) {
            return false;
        }
        InspectorServiceAttributes other = (InspectorServiceAttributes)obj;
        return Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.assessmentRunArn(), other.assessmentRunArn()) && Objects.equals(this.rulesPackageArn(), other.rulesPackageArn());
    }

    public final String toString() {
        return ToString.builder((String)"InspectorServiceAttributes").add("SchemaVersion", (Object)this.schemaVersion()).add("AssessmentRunArn", (Object)this.assessmentRunArn()).add("RulesPackageArn", (Object)this.rulesPackageArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "assessmentRunArn": {
                return Optional.ofNullable(clazz.cast(this.assessmentRunArn()));
            }
            case "rulesPackageArn": {
                return Optional.ofNullable(clazz.cast(this.rulesPackageArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InspectorServiceAttributes, T> g) {
        return obj -> g.apply((InspectorServiceAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer schemaVersion;
        private String assessmentRunArn;
        private String rulesPackageArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InspectorServiceAttributes model) {
            this.schemaVersion(model.schemaVersion);
            this.assessmentRunArn(model.assessmentRunArn);
            this.rulesPackageArn(model.rulesPackageArn);
        }

        public final Integer getSchemaVersion() {
            return this.schemaVersion;
        }

        public final void setSchemaVersion(Integer schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(Integer schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final String getAssessmentRunArn() {
            return this.assessmentRunArn;
        }

        public final void setAssessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
        }

        @Override
        public final Builder assessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
            return this;
        }

        public final String getRulesPackageArn() {
            return this.rulesPackageArn;
        }

        public final void setRulesPackageArn(String rulesPackageArn) {
            this.rulesPackageArn = rulesPackageArn;
        }

        @Override
        public final Builder rulesPackageArn(String rulesPackageArn) {
            this.rulesPackageArn = rulesPackageArn;
            return this;
        }

        public InspectorServiceAttributes build() {
            return new InspectorServiceAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InspectorServiceAttributes> {
        public Builder schemaVersion(Integer var1);

        public Builder assessmentRunArn(String var1);

        public Builder rulesPackageArn(String var1);
    }
}

