/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.BatchDescribeArnListCopier;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.services.inspector.model.Locale;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRulesPackagesRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, DescribeRulesPackagesRequest> {
    private static final SdkField<List<String>> RULES_PACKAGE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rulesPackageArns").getter(DescribeRulesPackagesRequest.getter(DescribeRulesPackagesRequest::rulesPackageArns)).setter(DescribeRulesPackagesRequest.setter(Builder::rulesPackageArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackageArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(DescribeRulesPackagesRequest.getter(DescribeRulesPackagesRequest::localeAsString)).setter(DescribeRulesPackagesRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_PACKAGE_ARNS_FIELD, LOCALE_FIELD));
    private final List<String> rulesPackageArns;
    private final String locale;

    private DescribeRulesPackagesRequest(BuilderImpl builder) {
        super(builder);
        this.rulesPackageArns = builder.rulesPackageArns;
        this.locale = builder.locale;
    }

    public final boolean hasRulesPackageArns() {
        return this.rulesPackageArns != null && !(this.rulesPackageArns instanceof SdkAutoConstructList);
    }

    public final List<String> rulesPackageArns() {
        return this.rulesPackageArns;
    }

    public final Locale locale() {
        return Locale.fromValue(this.locale);
    }

    public final String localeAsString() {
        return this.locale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRulesPackageArns() ? this.rulesPackageArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.localeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRulesPackagesRequest)) {
            return false;
        }
        DescribeRulesPackagesRequest other = (DescribeRulesPackagesRequest)((Object)obj);
        return this.hasRulesPackageArns() == other.hasRulesPackageArns() && Objects.equals(this.rulesPackageArns(), other.rulesPackageArns()) && Objects.equals(this.localeAsString(), other.localeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRulesPackagesRequest").add("RulesPackageArns", this.hasRulesPackageArns() ? this.rulesPackageArns() : null).add("Locale", (Object)this.localeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rulesPackageArns": {
                return Optional.ofNullable(clazz.cast(this.rulesPackageArns()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.localeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRulesPackagesRequest, T> g) {
        return obj -> g.apply((DescribeRulesPackagesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private List<String> rulesPackageArns = DefaultSdkAutoConstructList.getInstance();
        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRulesPackagesRequest model) {
            super(model);
            this.rulesPackageArns(model.rulesPackageArns);
            this.locale(model.locale);
        }

        public final Collection<String> getRulesPackageArns() {
            if (this.rulesPackageArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rulesPackageArns;
        }

        public final void setRulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = BatchDescribeArnListCopier.copy(rulesPackageArns);
        }

        @Override
        public final Builder rulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = BatchDescribeArnListCopier.copy(rulesPackageArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackageArns(String ... rulesPackageArns) {
            this.rulesPackageArns(Arrays.asList(rulesPackageArns));
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRulesPackagesRequest build() {
            return new DescribeRulesPackagesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRulesPackagesRequest> {
        public Builder rulesPackageArns(Collection<String> var1);

        public Builder rulesPackageArns(String ... var1);

        public Builder locale(String var1);

        public Builder locale(Locale var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

