/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector.model.AssessmentTargetFilter;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssessmentTargetsRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, ListAssessmentTargetsRequest> {
    private static final SdkField<AssessmentTargetFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filter").getter(ListAssessmentTargetsRequest.getter(ListAssessmentTargetsRequest::filter)).setter(ListAssessmentTargetsRequest.setter(Builder::filter)).constructor(AssessmentTargetFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssessmentTargetsRequest.getter(ListAssessmentTargetsRequest::nextToken)).setter(ListAssessmentTargetsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAssessmentTargetsRequest.getter(ListAssessmentTargetsRequest::maxResults)).setter(ListAssessmentTargetsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAssessmentTargetsRequest.memberNameToFieldInitializer();
    private final AssessmentTargetFilter filter;
    private final String nextToken;
    private final Integer maxResults;

    private ListAssessmentTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final AssessmentTargetFilter filter() {
        return this.filter;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentTargetsRequest)) {
            return false;
        }
        ListAssessmentTargetsRequest other = (ListAssessmentTargetsRequest)((Object)obj);
        return Objects.equals(this.filter(), other.filter()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssessmentTargetsRequest").add("Filter", (Object)this.filter()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filter", FILTER_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentTargetsRequest, T> g) {
        return obj -> g.apply((ListAssessmentTargetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private AssessmentTargetFilter filter;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentTargetsRequest model) {
            super(model);
            this.filter(model.filter);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final AssessmentTargetFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(AssessmentTargetFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(AssessmentTargetFilter filter) {
            this.filter = filter;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssessmentTargetsRequest build() {
            return new ListAssessmentTargetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssessmentTargetsRequest> {
        public Builder filter(AssessmentTargetFilter var1);

        default public Builder filter(Consumer<AssessmentTargetFilter.Builder> filter) {
            return this.filter((AssessmentTargetFilter)((AssessmentTargetFilter.Builder)AssessmentTargetFilter.builder().applyMutation(filter)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

