/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReportFileFormat {
    HTML("HTML"),
    PDF("PDF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReportFileFormat> VALUE_MAP;
    private final String value;

    private ReportFileFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReportFileFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReportFileFormat> knownValues() {
        EnumSet<ReportFileFormat> knownValues = EnumSet.allOf(ReportFileFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReportFileFormat.class, ReportFileFormat::toString);
    }
}

