/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourceGroupResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, CreateResourceGroupResponse> {
    private static final SdkField<String> RESOURCE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateResourceGroupResponse.getter(CreateResourceGroupResponse::resourceGroupArn)).setter(CreateResourceGroupResponse.setter(Builder::resourceGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_ARN_FIELD));
    private final String resourceGroupArn;

    private CreateResourceGroupResponse(BuilderImpl builder) {
        super(builder);
        this.resourceGroupArn = builder.resourceGroupArn;
    }

    public String resourceGroupArn() {
        return this.resourceGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceGroupResponse)) {
            return false;
        }
        CreateResourceGroupResponse other = (CreateResourceGroupResponse)((Object)obj);
        return Objects.equals(this.resourceGroupArn(), other.resourceGroupArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateResourceGroupResponse").add("ResourceGroupArn", (Object)this.resourceGroupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceGroupArn": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceGroupResponse, T> g) {
        return obj -> g.apply((CreateResourceGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private String resourceGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceGroupResponse model) {
            super(model);
            this.resourceGroupArn(model.resourceGroupArn);
        }

        public final String getResourceGroupArn() {
            return this.resourceGroupArn;
        }

        @Override
        public final Builder resourceGroupArn(String resourceGroupArn) {
            this.resourceGroupArn = resourceGroupArn;
            return this;
        }

        public final void setResourceGroupArn(String resourceGroupArn) {
            this.resourceGroupArn = resourceGroupArn;
        }

        @Override
        public CreateResourceGroupResponse build() {
            return new CreateResourceGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResourceGroupResponse> {
        public Builder resourceGroupArn(String var1);
    }
}

