/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector.model.AssessmentRunState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentRunStateChange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentRunStateChange> {
    private static final SdkField<Instant> STATE_CHANGED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AssessmentRunStateChange.getter(AssessmentRunStateChange::stateChangedAt)).setter(AssessmentRunStateChange.setter(Builder::stateChangedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateChangedAt").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssessmentRunStateChange.getter(AssessmentRunStateChange::stateAsString)).setter(AssessmentRunStateChange.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_CHANGED_AT_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant stateChangedAt;
    private final String state;

    private AssessmentRunStateChange(BuilderImpl builder) {
        this.stateChangedAt = builder.stateChangedAt;
        this.state = builder.state;
    }

    public Instant stateChangedAt() {
        return this.stateChangedAt;
    }

    public AssessmentRunState state() {
        return AssessmentRunState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentRunStateChange)) {
            return false;
        }
        AssessmentRunStateChange other = (AssessmentRunStateChange)obj;
        return Objects.equals(this.stateChangedAt(), other.stateChangedAt()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public String toString() {
        return ToString.builder((String)"AssessmentRunStateChange").add("StateChangedAt", (Object)this.stateChangedAt()).add("State", (Object)this.stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateChangedAt": {
                return Optional.ofNullable(clazz.cast(this.stateChangedAt()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentRunStateChange, T> g) {
        return obj -> g.apply((AssessmentRunStateChange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant stateChangedAt;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentRunStateChange model) {
            this.stateChangedAt(model.stateChangedAt);
            this.state(model.state);
        }

        public final Instant getStateChangedAt() {
            return this.stateChangedAt;
        }

        @Override
        public final Builder stateChangedAt(Instant stateChangedAt) {
            this.stateChangedAt = stateChangedAt;
            return this;
        }

        public final void setStateChangedAt(Instant stateChangedAt) {
            this.stateChangedAt = stateChangedAt;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AssessmentRunState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public AssessmentRunStateChange build() {
            return new AssessmentRunStateChange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentRunStateChange> {
        public Builder stateChangedAt(Instant var1);

        public Builder state(String var1);

        public Builder state(AssessmentRunState var1);
    }
}

