/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata about the Amazon Inspector application data metrics collected by the agent. This data type is used as
 * the response element in the <a>GetTelemetryMetadata</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TelemetryMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<TelemetryMetadata.Builder, TelemetryMetadata> {
    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TelemetryMetadata::messageType)).setter(setter(Builder::messageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageType").build()).build();

    private static final SdkField<Long> COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TelemetryMetadata::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<Long> DATA_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TelemetryMetadata::dataSize)).setter(setter(Builder::dataSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_TYPE_FIELD,
            COUNT_FIELD, DATA_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String messageType;

    private final Long count;

    private final Long dataSize;

    private TelemetryMetadata(BuilderImpl builder) {
        this.messageType = builder.messageType;
        this.count = builder.count;
        this.dataSize = builder.dataSize;
    }

    /**
     * <p>
     * A specific type of behavioral data that is collected by the agent.
     * </p>
     * 
     * @return A specific type of behavioral data that is collected by the agent.
     */
    public String messageType() {
        return messageType;
    }

    /**
     * <p>
     * The count of messages that the agent sends to the Amazon Inspector service.
     * </p>
     * 
     * @return The count of messages that the agent sends to the Amazon Inspector service.
     */
    public Long count() {
        return count;
    }

    /**
     * <p>
     * The data size of messages that the agent sends to the Amazon Inspector service.
     * </p>
     * 
     * @return The data size of messages that the agent sends to the Amazon Inspector service.
     */
    public Long dataSize() {
        return dataSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageType());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(dataSize());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryMetadata)) {
            return false;
        }
        TelemetryMetadata other = (TelemetryMetadata) obj;
        return Objects.equals(messageType(), other.messageType()) && Objects.equals(count(), other.count())
                && Objects.equals(dataSize(), other.dataSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TelemetryMetadata").add("MessageType", messageType()).add("Count", count())
                .add("DataSize", dataSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageType":
            return Optional.ofNullable(clazz.cast(messageType()));
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "dataSize":
            return Optional.ofNullable(clazz.cast(dataSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TelemetryMetadata, T> g) {
        return obj -> g.apply((TelemetryMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TelemetryMetadata> {
        /**
         * <p>
         * A specific type of behavioral data that is collected by the agent.
         * </p>
         * 
         * @param messageType
         *        A specific type of behavioral data that is collected by the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageType(String messageType);

        /**
         * <p>
         * The count of messages that the agent sends to the Amazon Inspector service.
         * </p>
         * 
         * @param count
         *        The count of messages that the agent sends to the Amazon Inspector service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Long count);

        /**
         * <p>
         * The data size of messages that the agent sends to the Amazon Inspector service.
         * </p>
         * 
         * @param dataSize
         *        The data size of messages that the agent sends to the Amazon Inspector service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSize(Long dataSize);
    }

    static final class BuilderImpl implements Builder {
        private String messageType;

        private Long count;

        private Long dataSize;

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryMetadata model) {
            messageType(model.messageType);
            count(model.count);
            dataSize(model.dataSize);
        }

        public final String getMessageType() {
            return messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        public final Long getCount() {
            return count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        public final Long getDataSize() {
            return dataSize;
        }

        @Override
        public final Builder dataSize(Long dataSize) {
            this.dataSize = dataSize;
            return this;
        }

        public final void setDataSize(Long dataSize) {
            this.dataSize = dataSize;
        }

        @Override
        public TelemetryMetadata build() {
            return new TelemetryMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
