/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateExclusionsPreviewResponse extends InspectorResponse implements
        ToCopyableBuilder<CreateExclusionsPreviewResponse.Builder, CreateExclusionsPreviewResponse> {
    private static final SdkField<String> PREVIEW_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateExclusionsPreviewResponse::previewToken)).setter(setter(Builder::previewToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previewToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREVIEW_TOKEN_FIELD));

    private final String previewToken;

    private CreateExclusionsPreviewResponse(BuilderImpl builder) {
        super(builder);
        this.previewToken = builder.previewToken;
    }

    /**
     * <p>
     * Specifies the unique identifier of the requested exclusions preview. You can use the unique identifier to
     * retrieve the exclusions preview when running the GetExclusionsPreview API.
     * </p>
     * 
     * @return Specifies the unique identifier of the requested exclusions preview. You can use the unique identifier to
     *         retrieve the exclusions preview when running the GetExclusionsPreview API.
     */
    public String previewToken() {
        return previewToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(previewToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExclusionsPreviewResponse)) {
            return false;
        }
        CreateExclusionsPreviewResponse other = (CreateExclusionsPreviewResponse) obj;
        return Objects.equals(previewToken(), other.previewToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateExclusionsPreviewResponse").add("PreviewToken", previewToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "previewToken":
            return Optional.ofNullable(clazz.cast(previewToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExclusionsPreviewResponse, T> g) {
        return obj -> g.apply((CreateExclusionsPreviewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateExclusionsPreviewResponse> {
        /**
         * <p>
         * Specifies the unique identifier of the requested exclusions preview. You can use the unique identifier to
         * retrieve the exclusions preview when running the GetExclusionsPreview API.
         * </p>
         * 
         * @param previewToken
         *        Specifies the unique identifier of the requested exclusions preview. You can use the unique identifier
         *        to retrieve the exclusions preview when running the GetExclusionsPreview API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previewToken(String previewToken);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private String previewToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExclusionsPreviewResponse model) {
            super(model);
            previewToken(model.previewToken);
        }

        public final String getPreviewToken() {
            return previewToken;
        }

        @Override
        public final Builder previewToken(String previewToken) {
            this.previewToken = previewToken;
            return this;
        }

        public final void setPreviewToken(String previewToken) {
            this.previewToken = previewToken;
        }

        @Override
        public CreateExclusionsPreviewResponse build() {
            return new CreateExclusionsPreviewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
