/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * You cannot perform a specified action if an assessment run is currently in progress.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentRunInProgressException extends InspectorException implements
        ToCopyableBuilder<AssessmentRunInProgressException.Builder, AssessmentRunInProgressException> {
    private static final SdkField<List<String>> ASSESSMENT_RUN_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AssessmentRunInProgressException::assessmentRunArns))
            .setter(setter(Builder::assessmentRunArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ASSESSMENT_RUN_ARNS_TRUNCATED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AssessmentRunInProgressException::assessmentRunArnsTruncated))
            .setter(setter(Builder::assessmentRunArnsTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArnsTruncated").build())
            .build();

    private static final SdkField<Boolean> CAN_RETRY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AssessmentRunInProgressException::canRetry)).setter(setter(Builder::canRetry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canRetry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_RUN_ARNS_FIELD,
            ASSESSMENT_RUN_ARNS_TRUNCATED_FIELD, CAN_RETRY_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> assessmentRunArns;

    private final Boolean assessmentRunArnsTruncated;

    private final Boolean canRetry;

    private AssessmentRunInProgressException(BuilderImpl builder) {
        super(builder);
        this.assessmentRunArns = builder.assessmentRunArns;
        this.assessmentRunArnsTruncated = builder.assessmentRunArnsTruncated;
        this.canRetry = builder.canRetry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns true if the AssessmentRunArns property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAssessmentRunArns() {
        return assessmentRunArns != null && !(assessmentRunArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the assessment runs that are currently in progress.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssessmentRunArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ARNs of the assessment runs that are currently in progress.
     */
    public List<String> assessmentRunArns() {
        return assessmentRunArns;
    }

    /**
     * <p>
     * Boolean value that indicates whether the ARN list of the assessment runs is truncated.
     * </p>
     * 
     * @return Boolean value that indicates whether the ARN list of the assessment runs is truncated.
     */
    public Boolean assessmentRunArnsTruncated() {
        return assessmentRunArnsTruncated;
    }

    /**
     * <p>
     * You can immediately retry your request.
     * </p>
     * 
     * @return You can immediately retry your request.
     */
    public Boolean canRetry() {
        return canRetry;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentRunInProgressException, T> g) {
        return obj -> g.apply((AssessmentRunInProgressException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentRunInProgressException>,
            InspectorException.Builder {
        /**
         * <p>
         * The ARNs of the assessment runs that are currently in progress.
         * </p>
         * 
         * @param assessmentRunArns
         *        The ARNs of the assessment runs that are currently in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunArns(Collection<String> assessmentRunArns);

        /**
         * <p>
         * The ARNs of the assessment runs that are currently in progress.
         * </p>
         * 
         * @param assessmentRunArns
         *        The ARNs of the assessment runs that are currently in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunArns(String... assessmentRunArns);

        /**
         * <p>
         * Boolean value that indicates whether the ARN list of the assessment runs is truncated.
         * </p>
         * 
         * @param assessmentRunArnsTruncated
         *        Boolean value that indicates whether the ARN list of the assessment runs is truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunArnsTruncated(Boolean assessmentRunArnsTruncated);

        /**
         * <p>
         * You can immediately retry your request.
         * </p>
         * 
         * @param canRetry
         *        You can immediately retry your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canRetry(Boolean canRetry);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends InspectorException.BuilderImpl implements Builder {
        private List<String> assessmentRunArns = DefaultSdkAutoConstructList.getInstance();

        private Boolean assessmentRunArnsTruncated;

        private Boolean canRetry;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentRunInProgressException model) {
            super(model);
            assessmentRunArns(model.assessmentRunArns);
            assessmentRunArnsTruncated(model.assessmentRunArnsTruncated);
            canRetry(model.canRetry);
        }

        public final Collection<String> getAssessmentRunArns() {
            return assessmentRunArns;
        }

        @Override
        public final Builder assessmentRunArns(Collection<String> assessmentRunArns) {
            this.assessmentRunArns = AssessmentRunInProgressArnListCopier.copy(assessmentRunArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentRunArns(String... assessmentRunArns) {
            assessmentRunArns(Arrays.asList(assessmentRunArns));
            return this;
        }

        public final void setAssessmentRunArns(Collection<String> assessmentRunArns) {
            this.assessmentRunArns = AssessmentRunInProgressArnListCopier.copy(assessmentRunArns);
        }

        public final Boolean getAssessmentRunArnsTruncated() {
            return assessmentRunArnsTruncated;
        }

        @Override
        public final Builder assessmentRunArnsTruncated(Boolean assessmentRunArnsTruncated) {
            this.assessmentRunArnsTruncated = assessmentRunArnsTruncated;
            return this;
        }

        public final void setAssessmentRunArnsTruncated(Boolean assessmentRunArnsTruncated) {
            this.assessmentRunArnsTruncated = assessmentRunArnsTruncated;
        }

        public final Boolean getCanRetry() {
            return canRetry;
        }

        @Override
        public final Builder canRetry(Boolean canRetry) {
            this.canRetry = canRetry;
            return this;
        }

        public final void setCanRetry(Boolean canRetry) {
            this.canRetry = canRetry;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public AssessmentRunInProgressException build() {
            return new AssessmentRunInProgressException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
