/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.services.imagebuilder.model.LatestVersionReferences;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateContainerRecipeResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, CreateContainerRecipeResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(CreateContainerRecipeResponse.getter(CreateContainerRecipeResponse::requestId)).setter(CreateContainerRecipeResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateContainerRecipeResponse.getter(CreateContainerRecipeResponse::clientToken)).setter(CreateContainerRecipeResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> CONTAINER_RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerRecipeArn").getter(CreateContainerRecipeResponse.getter(CreateContainerRecipeResponse::containerRecipeArn)).setter(CreateContainerRecipeResponse.setter(Builder::containerRecipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRecipeArn").build()}).build();
    private static final SdkField<LatestVersionReferences> LATEST_VERSION_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestVersionReferences").getter(CreateContainerRecipeResponse.getter(CreateContainerRecipeResponse::latestVersionReferences)).setter(CreateContainerRecipeResponse.setter(Builder::latestVersionReferences)).constructor(LatestVersionReferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersionReferences").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, CLIENT_TOKEN_FIELD, CONTAINER_RECIPE_ARN_FIELD, LATEST_VERSION_REFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateContainerRecipeResponse.memberNameToFieldInitializer();
    private final String requestIdValue;
    private final String clientToken;
    private final String containerRecipeArn;
    private final LatestVersionReferences latestVersionReferences;

    private CreateContainerRecipeResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.clientToken = builder.clientToken;
        this.containerRecipeArn = builder.containerRecipeArn;
        this.latestVersionReferences = builder.latestVersionReferences;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String containerRecipeArn() {
        return this.containerRecipeArn;
    }

    public final LatestVersionReferences latestVersionReferences() {
        return this.latestVersionReferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionReferences());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerRecipeResponse)) {
            return false;
        }
        CreateContainerRecipeResponse other = (CreateContainerRecipeResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.containerRecipeArn(), other.containerRecipeArn()) && Objects.equals(this.latestVersionReferences(), other.latestVersionReferences());
    }

    public final String toString() {
        return ToString.builder((String)"CreateContainerRecipeResponse").add("RequestId", (Object)this.requestId()).add("ClientToken", (Object)this.clientToken()).add("ContainerRecipeArn", (Object)this.containerRecipeArn()).add("LatestVersionReferences", (Object)this.latestVersionReferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "containerRecipeArn": {
                return Optional.ofNullable(clazz.cast(this.containerRecipeArn()));
            }
            case "latestVersionReferences": {
                return Optional.ofNullable(clazz.cast(this.latestVersionReferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("containerRecipeArn", CONTAINER_RECIPE_ARN_FIELD);
        map.put("latestVersionReferences", LATEST_VERSION_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateContainerRecipeResponse, T> g) {
        return obj -> g.apply((CreateContainerRecipeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private String clientToken;
        private String containerRecipeArn;
        private LatestVersionReferences latestVersionReferences;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContainerRecipeResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.clientToken(model.clientToken);
            this.containerRecipeArn(model.containerRecipeArn);
            this.latestVersionReferences(model.latestVersionReferences);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getContainerRecipeArn() {
            return this.containerRecipeArn;
        }

        public final void setContainerRecipeArn(String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
        }

        @Override
        public final Builder containerRecipeArn(String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
            return this;
        }

        public final LatestVersionReferences.Builder getLatestVersionReferences() {
            return this.latestVersionReferences != null ? this.latestVersionReferences.toBuilder() : null;
        }

        public final void setLatestVersionReferences(LatestVersionReferences.BuilderImpl latestVersionReferences) {
            this.latestVersionReferences = latestVersionReferences != null ? latestVersionReferences.build() : null;
        }

        @Override
        public final Builder latestVersionReferences(LatestVersionReferences latestVersionReferences) {
            this.latestVersionReferences = latestVersionReferences;
            return this;
        }

        @Override
        public CreateContainerRecipeResponse build() {
            return new CreateContainerRecipeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateContainerRecipeResponse> {
        public Builder requestId(String var1);

        public Builder clientToken(String var1);

        public Builder containerRecipeArn(String var1);

        public Builder latestVersionReferences(LatestVersionReferences var1);

        default public Builder latestVersionReferences(Consumer<LatestVersionReferences.Builder> latestVersionReferences) {
            return this.latestVersionReferences((LatestVersionReferences)((LatestVersionReferences.Builder)LatestVersionReferences.builder().applyMutation(latestVersionReferences)).build());
        }
    }
}

