/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.AccountListCopier;
import software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmisLastLaunched;
import software.amazon.awssdk.services.imagebuilder.model.StringListCopier;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecyclePolicyDetailExclusionRulesAmis
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecyclePolicyDetailExclusionRulesAmis> {
    private static final SdkField<Boolean> IS_PUBLIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isPublic").getter(LifecyclePolicyDetailExclusionRulesAmis.getter(LifecyclePolicyDetailExclusionRulesAmis::isPublic)).setter(LifecyclePolicyDetailExclusionRulesAmis.setter(Builder::isPublic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPublic").build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regions").getter(LifecyclePolicyDetailExclusionRulesAmis.getter(LifecyclePolicyDetailExclusionRulesAmis::regions)).setter(LifecyclePolicyDetailExclusionRulesAmis.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SHARED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sharedAccounts").getter(LifecyclePolicyDetailExclusionRulesAmis.getter(LifecyclePolicyDetailExclusionRulesAmis::sharedAccounts)).setter(LifecyclePolicyDetailExclusionRulesAmis.setter(Builder::sharedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LifecyclePolicyDetailExclusionRulesAmisLastLaunched> LAST_LAUNCHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lastLaunched").getter(LifecyclePolicyDetailExclusionRulesAmis.getter(LifecyclePolicyDetailExclusionRulesAmis::lastLaunched)).setter(LifecyclePolicyDetailExclusionRulesAmis.setter(Builder::lastLaunched)).constructor(LifecyclePolicyDetailExclusionRulesAmisLastLaunched::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastLaunched").build()}).build();
    private static final SdkField<Map<String, String>> TAG_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tagMap").getter(LifecyclePolicyDetailExclusionRulesAmis.getter(LifecyclePolicyDetailExclusionRulesAmis::tagMap)).setter(LifecyclePolicyDetailExclusionRulesAmis.setter(Builder::tagMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_PUBLIC_FIELD, REGIONS_FIELD, SHARED_ACCOUNTS_FIELD, LAST_LAUNCHED_FIELD, TAG_MAP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LifecyclePolicyDetailExclusionRulesAmis.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean isPublic;
    private final List<String> regions;
    private final List<String> sharedAccounts;
    private final LifecyclePolicyDetailExclusionRulesAmisLastLaunched lastLaunched;
    private final Map<String, String> tagMap;

    private LifecyclePolicyDetailExclusionRulesAmis(BuilderImpl builder) {
        this.isPublic = builder.isPublic;
        this.regions = builder.regions;
        this.sharedAccounts = builder.sharedAccounts;
        this.lastLaunched = builder.lastLaunched;
        this.tagMap = builder.tagMap;
    }

    public final Boolean isPublic() {
        return this.isPublic;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public final boolean hasSharedAccounts() {
        return this.sharedAccounts != null && !(this.sharedAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> sharedAccounts() {
        return this.sharedAccounts;
    }

    public final LifecyclePolicyDetailExclusionRulesAmisLastLaunched lastLaunched() {
        return this.lastLaunched;
    }

    public final boolean hasTagMap() {
        return this.tagMap != null && !(this.tagMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tagMap() {
        return this.tagMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isPublic());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSharedAccounts() ? this.sharedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastLaunched());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagMap() ? this.tagMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyDetailExclusionRulesAmis)) {
            return false;
        }
        LifecyclePolicyDetailExclusionRulesAmis other = (LifecyclePolicyDetailExclusionRulesAmis)obj;
        return Objects.equals(this.isPublic(), other.isPublic()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions()) && this.hasSharedAccounts() == other.hasSharedAccounts() && Objects.equals(this.sharedAccounts(), other.sharedAccounts()) && Objects.equals(this.lastLaunched(), other.lastLaunched()) && this.hasTagMap() == other.hasTagMap() && Objects.equals(this.tagMap(), other.tagMap());
    }

    public final String toString() {
        return ToString.builder((String)"LifecyclePolicyDetailExclusionRulesAmis").add("IsPublic", (Object)this.isPublic()).add("Regions", this.hasRegions() ? this.regions() : null).add("SharedAccounts", this.hasSharedAccounts() ? this.sharedAccounts() : null).add("LastLaunched", (Object)this.lastLaunched()).add("TagMap", this.hasTagMap() ? this.tagMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isPublic": {
                return Optional.ofNullable(clazz.cast(this.isPublic()));
            }
            case "regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
            case "sharedAccounts": {
                return Optional.ofNullable(clazz.cast(this.sharedAccounts()));
            }
            case "lastLaunched": {
                return Optional.ofNullable(clazz.cast(this.lastLaunched()));
            }
            case "tagMap": {
                return Optional.ofNullable(clazz.cast(this.tagMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isPublic", IS_PUBLIC_FIELD);
        map.put("regions", REGIONS_FIELD);
        map.put("sharedAccounts", SHARED_ACCOUNTS_FIELD);
        map.put("lastLaunched", LAST_LAUNCHED_FIELD);
        map.put("tagMap", TAG_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyDetailExclusionRulesAmis, T> g) {
        return obj -> g.apply((LifecyclePolicyDetailExclusionRulesAmis)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isPublic;
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private List<String> sharedAccounts = DefaultSdkAutoConstructList.getInstance();
        private LifecyclePolicyDetailExclusionRulesAmisLastLaunched lastLaunched;
        private Map<String, String> tagMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyDetailExclusionRulesAmis model) {
            this.isPublic(model.isPublic);
            this.regions(model.regions);
            this.sharedAccounts(model.sharedAccounts);
            this.lastLaunched(model.lastLaunched);
            this.tagMap(model.tagMap);
        }

        public final Boolean getIsPublic() {
            return this.isPublic;
        }

        public final void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        @Override
        public final Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = StringListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = StringListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final Collection<String> getSharedAccounts() {
            if (this.sharedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sharedAccounts;
        }

        public final void setSharedAccounts(Collection<String> sharedAccounts) {
            this.sharedAccounts = AccountListCopier.copy(sharedAccounts);
        }

        @Override
        public final Builder sharedAccounts(Collection<String> sharedAccounts) {
            this.sharedAccounts = AccountListCopier.copy(sharedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedAccounts(String ... sharedAccounts) {
            this.sharedAccounts(Arrays.asList(sharedAccounts));
            return this;
        }

        public final LifecyclePolicyDetailExclusionRulesAmisLastLaunched.Builder getLastLaunched() {
            return this.lastLaunched != null ? this.lastLaunched.toBuilder() : null;
        }

        public final void setLastLaunched(LifecyclePolicyDetailExclusionRulesAmisLastLaunched.BuilderImpl lastLaunched) {
            this.lastLaunched = lastLaunched != null ? lastLaunched.build() : null;
        }

        @Override
        public final Builder lastLaunched(LifecyclePolicyDetailExclusionRulesAmisLastLaunched lastLaunched) {
            this.lastLaunched = lastLaunched;
            return this;
        }

        public final Map<String, String> getTagMap() {
            if (this.tagMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tagMap;
        }

        public final void setTagMap(Map<String, String> tagMap) {
            this.tagMap = TagMapCopier.copy(tagMap);
        }

        @Override
        public final Builder tagMap(Map<String, String> tagMap) {
            this.tagMap = TagMapCopier.copy(tagMap);
            return this;
        }

        public LifecyclePolicyDetailExclusionRulesAmis build() {
            return new LifecyclePolicyDetailExclusionRulesAmis(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecyclePolicyDetailExclusionRulesAmis> {
        public Builder isPublic(Boolean var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder sharedAccounts(Collection<String> var1);

        public Builder sharedAccounts(String ... var1);

        public Builder lastLaunched(LifecyclePolicyDetailExclusionRulesAmisLastLaunched var1);

        default public Builder lastLaunched(Consumer<LifecyclePolicyDetailExclusionRulesAmisLastLaunched.Builder> lastLaunched) {
            return this.lastLaunched((LifecyclePolicyDetailExclusionRulesAmisLastLaunched)((LifecyclePolicyDetailExclusionRulesAmisLastLaunched.Builder)LifecyclePolicyDetailExclusionRulesAmisLastLaunched.builder().applyMutation(lastLaunched)).build());
        }

        public Builder tagMap(Map<String, String> var1);
    }
}

