/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecyclePolicyDetailExclusionRules
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecyclePolicyDetailExclusionRules> {
    private static final SdkField<Map<String, String>> TAG_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tagMap").getter(LifecyclePolicyDetailExclusionRules.getter(LifecyclePolicyDetailExclusionRules::tagMap)).setter(LifecyclePolicyDetailExclusionRules.setter(Builder::tagMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<LifecyclePolicyDetailExclusionRulesAmis> AMIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("amis").getter(LifecyclePolicyDetailExclusionRules.getter(LifecyclePolicyDetailExclusionRules::amis)).setter(LifecyclePolicyDetailExclusionRules.setter(Builder::amis)).constructor(LifecyclePolicyDetailExclusionRulesAmis::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amis").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_MAP_FIELD, AMIS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LifecyclePolicyDetailExclusionRules.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> tagMap;
    private final LifecyclePolicyDetailExclusionRulesAmis amis;

    private LifecyclePolicyDetailExclusionRules(BuilderImpl builder) {
        this.tagMap = builder.tagMap;
        this.amis = builder.amis;
    }

    public final boolean hasTagMap() {
        return this.tagMap != null && !(this.tagMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tagMap() {
        return this.tagMap;
    }

    public final LifecyclePolicyDetailExclusionRulesAmis amis() {
        return this.amis;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagMap() ? this.tagMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.amis());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyDetailExclusionRules)) {
            return false;
        }
        LifecyclePolicyDetailExclusionRules other = (LifecyclePolicyDetailExclusionRules)obj;
        return this.hasTagMap() == other.hasTagMap() && Objects.equals(this.tagMap(), other.tagMap()) && Objects.equals(this.amis(), other.amis());
    }

    public final String toString() {
        return ToString.builder((String)"LifecyclePolicyDetailExclusionRules").add("TagMap", this.hasTagMap() ? this.tagMap() : null).add("Amis", (Object)this.amis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tagMap": {
                return Optional.ofNullable(clazz.cast(this.tagMap()));
            }
            case "amis": {
                return Optional.ofNullable(clazz.cast(this.amis()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tagMap", TAG_MAP_FIELD);
        map.put("amis", AMIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyDetailExclusionRules, T> g) {
        return obj -> g.apply((LifecyclePolicyDetailExclusionRules)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> tagMap = DefaultSdkAutoConstructMap.getInstance();
        private LifecyclePolicyDetailExclusionRulesAmis amis;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyDetailExclusionRules model) {
            this.tagMap(model.tagMap);
            this.amis(model.amis);
        }

        public final Map<String, String> getTagMap() {
            if (this.tagMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tagMap;
        }

        public final void setTagMap(Map<String, String> tagMap) {
            this.tagMap = TagMapCopier.copy(tagMap);
        }

        @Override
        public final Builder tagMap(Map<String, String> tagMap) {
            this.tagMap = TagMapCopier.copy(tagMap);
            return this;
        }

        public final LifecyclePolicyDetailExclusionRulesAmis.Builder getAmis() {
            return this.amis != null ? this.amis.toBuilder() : null;
        }

        public final void setAmis(LifecyclePolicyDetailExclusionRulesAmis.BuilderImpl amis) {
            this.amis = amis != null ? amis.build() : null;
        }

        @Override
        public final Builder amis(LifecyclePolicyDetailExclusionRulesAmis amis) {
            this.amis = amis;
            return this;
        }

        public LifecyclePolicyDetailExclusionRules build() {
            return new LifecyclePolicyDetailExclusionRules(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecyclePolicyDetailExclusionRules> {
        public Builder tagMap(Map<String, String> var1);

        public Builder amis(LifecyclePolicyDetailExclusionRulesAmis var1);

        default public Builder amis(Consumer<LifecyclePolicyDetailExclusionRulesAmis.Builder> amis) {
            return this.amis((LifecyclePolicyDetailExclusionRulesAmis)((LifecyclePolicyDetailExclusionRulesAmis.Builder)LifecyclePolicyDetailExclusionRulesAmis.builder().applyMutation(amis)).build());
        }
    }
}

