/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowExecutionStatus;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowExecutionMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowExecutionMetadata> {
    private static final SdkField<String> WORKFLOW_BUILD_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowBuildVersionArn").getter(WorkflowExecutionMetadata.getter(WorkflowExecutionMetadata::workflowBuildVersionArn)).setter(WorkflowExecutionMetadata.setter(Builder::workflowBuildVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowBuildVersionArn").build()}).build();
    private static final SdkField<String> WORKFLOW_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowExecutionId").getter(WorkflowExecutionMetadata.getter(WorkflowExecutionMetadata::workflowExecutionId)).setter(WorkflowExecutionMetadata.setter(Builder::workflowExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowExecutionId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(WorkflowExecutionMetadata.getter(WorkflowExecutionMetadata::typeAsString)).setter(WorkflowExecutionMetadata.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(WorkflowExecutionMetadata.getter(WorkflowExecutionMetadata::statusAsString)).setter(WorkflowExecutionMetadata.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(WorkflowExecutionMetadata.getter(WorkflowExecutionMetadata::message)).setter(WorkflowExecutionMetadata.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Integer> TOTAL_STEP_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalStepCount").getter(WorkflowExecutionMetadata.getter(WorkflowExecutionMetadata::totalStepCount)).setter(WorkflowExecutionMetadata.setter(Builder::totalStepCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalStepCount").build()}).build();
    private static final SdkField<Integer> TOTAL_STEPS_SUCCEEDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalStepsSucceeded").getter(WorkflowExecutionMetadata.getter(WorkflowExecutionMetadata::totalStepsSucceeded)).setter(WorkflowExecutionMetadata.setter(Builder::totalStepsSucceeded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalStepsSucceeded").build()}).build();
    private static final SdkField<Integer> TOTAL_STEPS_FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalStepsFailed").getter(WorkflowExecutionMetadata.getter(WorkflowExecutionMetadata::totalStepsFailed)).setter(WorkflowExecutionMetadata.setter(Builder::totalStepsFailed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalStepsFailed").build()}).build();
    private static final SdkField<Integer> TOTAL_STEPS_SKIPPED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalStepsSkipped").getter(WorkflowExecutionMetadata.getter(WorkflowExecutionMetadata::totalStepsSkipped)).setter(WorkflowExecutionMetadata.setter(Builder::totalStepsSkipped)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalStepsSkipped").build()}).build();
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startTime").getter(WorkflowExecutionMetadata.getter(WorkflowExecutionMetadata::startTime)).setter(WorkflowExecutionMetadata.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endTime").getter(WorkflowExecutionMetadata.getter(WorkflowExecutionMetadata::endTime)).setter(WorkflowExecutionMetadata.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> PARALLEL_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parallelGroup").getter(WorkflowExecutionMetadata.getter(WorkflowExecutionMetadata::parallelGroup)).setter(WorkflowExecutionMetadata.setter(Builder::parallelGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parallelGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_BUILD_VERSION_ARN_FIELD, WORKFLOW_EXECUTION_ID_FIELD, TYPE_FIELD, STATUS_FIELD, MESSAGE_FIELD, TOTAL_STEP_COUNT_FIELD, TOTAL_STEPS_SUCCEEDED_FIELD, TOTAL_STEPS_FAILED_FIELD, TOTAL_STEPS_SKIPPED_FIELD, START_TIME_FIELD, END_TIME_FIELD, PARALLEL_GROUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkflowExecutionMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String workflowBuildVersionArn;
    private final String workflowExecutionId;
    private final String type;
    private final String status;
    private final String message;
    private final Integer totalStepCount;
    private final Integer totalStepsSucceeded;
    private final Integer totalStepsFailed;
    private final Integer totalStepsSkipped;
    private final String startTime;
    private final String endTime;
    private final String parallelGroup;

    private WorkflowExecutionMetadata(BuilderImpl builder) {
        this.workflowBuildVersionArn = builder.workflowBuildVersionArn;
        this.workflowExecutionId = builder.workflowExecutionId;
        this.type = builder.type;
        this.status = builder.status;
        this.message = builder.message;
        this.totalStepCount = builder.totalStepCount;
        this.totalStepsSucceeded = builder.totalStepsSucceeded;
        this.totalStepsFailed = builder.totalStepsFailed;
        this.totalStepsSkipped = builder.totalStepsSkipped;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.parallelGroup = builder.parallelGroup;
    }

    public final String workflowBuildVersionArn() {
        return this.workflowBuildVersionArn;
    }

    public final String workflowExecutionId() {
        return this.workflowExecutionId;
    }

    public final WorkflowType type() {
        return WorkflowType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final WorkflowExecutionStatus status() {
        return WorkflowExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String message() {
        return this.message;
    }

    public final Integer totalStepCount() {
        return this.totalStepCount;
    }

    public final Integer totalStepsSucceeded() {
        return this.totalStepsSucceeded;
    }

    public final Integer totalStepsFailed() {
        return this.totalStepsFailed;
    }

    public final Integer totalStepsSkipped() {
        return this.totalStepsSkipped;
    }

    public final String startTime() {
        return this.startTime;
    }

    public final String endTime() {
        return this.endTime;
    }

    public final String parallelGroup() {
        return this.parallelGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowBuildVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalStepCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalStepsSucceeded());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalStepsFailed());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalStepsSkipped());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowExecutionMetadata)) {
            return false;
        }
        WorkflowExecutionMetadata other = (WorkflowExecutionMetadata)obj;
        return Objects.equals(this.workflowBuildVersionArn(), other.workflowBuildVersionArn()) && Objects.equals(this.workflowExecutionId(), other.workflowExecutionId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.totalStepCount(), other.totalStepCount()) && Objects.equals(this.totalStepsSucceeded(), other.totalStepsSucceeded()) && Objects.equals(this.totalStepsFailed(), other.totalStepsFailed()) && Objects.equals(this.totalStepsSkipped(), other.totalStepsSkipped()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.parallelGroup(), other.parallelGroup());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowExecutionMetadata").add("WorkflowBuildVersionArn", (Object)this.workflowBuildVersionArn()).add("WorkflowExecutionId", (Object)this.workflowExecutionId()).add("Type", (Object)this.typeAsString()).add("Status", (Object)this.statusAsString()).add("Message", (Object)this.message()).add("TotalStepCount", (Object)this.totalStepCount()).add("TotalStepsSucceeded", (Object)this.totalStepsSucceeded()).add("TotalStepsFailed", (Object)this.totalStepsFailed()).add("TotalStepsSkipped", (Object)this.totalStepsSkipped()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ParallelGroup", (Object)this.parallelGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowBuildVersionArn": {
                return Optional.ofNullable(clazz.cast(this.workflowBuildVersionArn()));
            }
            case "workflowExecutionId": {
                return Optional.ofNullable(clazz.cast(this.workflowExecutionId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "totalStepCount": {
                return Optional.ofNullable(clazz.cast(this.totalStepCount()));
            }
            case "totalStepsSucceeded": {
                return Optional.ofNullable(clazz.cast(this.totalStepsSucceeded()));
            }
            case "totalStepsFailed": {
                return Optional.ofNullable(clazz.cast(this.totalStepsFailed()));
            }
            case "totalStepsSkipped": {
                return Optional.ofNullable(clazz.cast(this.totalStepsSkipped()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "parallelGroup": {
                return Optional.ofNullable(clazz.cast(this.parallelGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflowBuildVersionArn", WORKFLOW_BUILD_VERSION_ARN_FIELD);
        map.put("workflowExecutionId", WORKFLOW_EXECUTION_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("totalStepCount", TOTAL_STEP_COUNT_FIELD);
        map.put("totalStepsSucceeded", TOTAL_STEPS_SUCCEEDED_FIELD);
        map.put("totalStepsFailed", TOTAL_STEPS_FAILED_FIELD);
        map.put("totalStepsSkipped", TOTAL_STEPS_SKIPPED_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("parallelGroup", PARALLEL_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowExecutionMetadata, T> g) {
        return obj -> g.apply((WorkflowExecutionMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workflowBuildVersionArn;
        private String workflowExecutionId;
        private String type;
        private String status;
        private String message;
        private Integer totalStepCount;
        private Integer totalStepsSucceeded;
        private Integer totalStepsFailed;
        private Integer totalStepsSkipped;
        private String startTime;
        private String endTime;
        private String parallelGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowExecutionMetadata model) {
            this.workflowBuildVersionArn(model.workflowBuildVersionArn);
            this.workflowExecutionId(model.workflowExecutionId);
            this.type(model.type);
            this.status(model.status);
            this.message(model.message);
            this.totalStepCount(model.totalStepCount);
            this.totalStepsSucceeded(model.totalStepsSucceeded);
            this.totalStepsFailed(model.totalStepsFailed);
            this.totalStepsSkipped(model.totalStepsSkipped);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.parallelGroup(model.parallelGroup);
        }

        public final String getWorkflowBuildVersionArn() {
            return this.workflowBuildVersionArn;
        }

        public final void setWorkflowBuildVersionArn(String workflowBuildVersionArn) {
            this.workflowBuildVersionArn = workflowBuildVersionArn;
        }

        @Override
        public final Builder workflowBuildVersionArn(String workflowBuildVersionArn) {
            this.workflowBuildVersionArn = workflowBuildVersionArn;
            return this;
        }

        public final String getWorkflowExecutionId() {
            return this.workflowExecutionId;
        }

        public final void setWorkflowExecutionId(String workflowExecutionId) {
            this.workflowExecutionId = workflowExecutionId;
        }

        @Override
        public final Builder workflowExecutionId(String workflowExecutionId) {
            this.workflowExecutionId = workflowExecutionId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WorkflowType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Integer getTotalStepCount() {
            return this.totalStepCount;
        }

        public final void setTotalStepCount(Integer totalStepCount) {
            this.totalStepCount = totalStepCount;
        }

        @Override
        public final Builder totalStepCount(Integer totalStepCount) {
            this.totalStepCount = totalStepCount;
            return this;
        }

        public final Integer getTotalStepsSucceeded() {
            return this.totalStepsSucceeded;
        }

        public final void setTotalStepsSucceeded(Integer totalStepsSucceeded) {
            this.totalStepsSucceeded = totalStepsSucceeded;
        }

        @Override
        public final Builder totalStepsSucceeded(Integer totalStepsSucceeded) {
            this.totalStepsSucceeded = totalStepsSucceeded;
            return this;
        }

        public final Integer getTotalStepsFailed() {
            return this.totalStepsFailed;
        }

        public final void setTotalStepsFailed(Integer totalStepsFailed) {
            this.totalStepsFailed = totalStepsFailed;
        }

        @Override
        public final Builder totalStepsFailed(Integer totalStepsFailed) {
            this.totalStepsFailed = totalStepsFailed;
            return this;
        }

        public final Integer getTotalStepsSkipped() {
            return this.totalStepsSkipped;
        }

        public final void setTotalStepsSkipped(Integer totalStepsSkipped) {
            this.totalStepsSkipped = totalStepsSkipped;
        }

        @Override
        public final Builder totalStepsSkipped(Integer totalStepsSkipped) {
            this.totalStepsSkipped = totalStepsSkipped;
            return this;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getParallelGroup() {
            return this.parallelGroup;
        }

        public final void setParallelGroup(String parallelGroup) {
            this.parallelGroup = parallelGroup;
        }

        @Override
        public final Builder parallelGroup(String parallelGroup) {
            this.parallelGroup = parallelGroup;
            return this;
        }

        public WorkflowExecutionMetadata build() {
            return new WorkflowExecutionMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowExecutionMetadata> {
        public Builder workflowBuildVersionArn(String var1);

        public Builder workflowExecutionId(String var1);

        public Builder type(String var1);

        public Builder type(WorkflowType var1);

        public Builder status(String var1);

        public Builder status(WorkflowExecutionStatus var1);

        public Builder message(String var1);

        public Builder totalStepCount(Integer var1);

        public Builder totalStepsSucceeded(Integer var1);

        public Builder totalStepsFailed(Integer var1);

        public Builder totalStepsSkipped(Integer var1);

        public Builder startTime(String var1);

        public Builder endTime(String var1);

        public Builder parallelGroup(String var1);
    }
}

