/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.DistributionConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDistributionConfigurationResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, GetDistributionConfigurationResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(GetDistributionConfigurationResponse.getter(GetDistributionConfigurationResponse::requestId)).setter(GetDistributionConfigurationResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<DistributionConfiguration> DISTRIBUTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("distributionConfiguration").getter(GetDistributionConfigurationResponse.getter(GetDistributionConfigurationResponse::distributionConfiguration)).setter(GetDistributionConfigurationResponse.setter(Builder::distributionConfiguration)).constructor(DistributionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, DISTRIBUTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("requestId", REQUEST_ID_FIELD);
            this.put("distributionConfiguration", DISTRIBUTION_CONFIGURATION_FIELD);
        }
    });
    private final String requestIdValue;
    private final DistributionConfiguration distributionConfiguration;

    private GetDistributionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.distributionConfiguration = builder.distributionConfiguration;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final DistributionConfiguration distributionConfiguration() {
        return this.distributionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDistributionConfigurationResponse)) {
            return false;
        }
        GetDistributionConfigurationResponse other = (GetDistributionConfigurationResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.distributionConfiguration(), other.distributionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GetDistributionConfigurationResponse").add("RequestId", (Object)this.requestId()).add("DistributionConfiguration", (Object)this.distributionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "distributionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.distributionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDistributionConfigurationResponse, T> g) {
        return obj -> g.apply((GetDistributionConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private DistributionConfiguration distributionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDistributionConfigurationResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.distributionConfiguration(model.distributionConfiguration);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final DistributionConfiguration.Builder getDistributionConfiguration() {
            return this.distributionConfiguration != null ? this.distributionConfiguration.toBuilder() : null;
        }

        public final void setDistributionConfiguration(DistributionConfiguration.BuilderImpl distributionConfiguration) {
            this.distributionConfiguration = distributionConfiguration != null ? distributionConfiguration.build() : null;
        }

        @Override
        public final Builder distributionConfiguration(DistributionConfiguration distributionConfiguration) {
            this.distributionConfiguration = distributionConfiguration;
            return this;
        }

        @Override
        public GetDistributionConfigurationResponse build() {
            return new GetDistributionConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDistributionConfigurationResponse> {
        public Builder requestId(String var1);

        public Builder distributionConfiguration(DistributionConfiguration var1);

        default public Builder distributionConfiguration(Consumer<DistributionConfiguration.Builder> distributionConfiguration) {
            return this.distributionConfiguration((DistributionConfiguration)((DistributionConfiguration.Builder)DistributionConfiguration.builder().applyMutation(distributionConfiguration)).build());
        }
    }
}

