/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.Distribution;
import software.amazon.awssdk.services.imagebuilder.model.DistributionListCopier;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDistributionConfigurationRequest
extends ImagebuilderRequest
implements ToCopyableBuilder<Builder, UpdateDistributionConfigurationRequest> {
    private static final SdkField<String> DISTRIBUTION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("distributionConfigurationArn").getter(UpdateDistributionConfigurationRequest.getter(UpdateDistributionConfigurationRequest::distributionConfigurationArn)).setter(UpdateDistributionConfigurationRequest.setter(Builder::distributionConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfigurationArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateDistributionConfigurationRequest.getter(UpdateDistributionConfigurationRequest::description)).setter(UpdateDistributionConfigurationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Distribution>> DISTRIBUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("distributions").getter(UpdateDistributionConfigurationRequest.getter(UpdateDistributionConfigurationRequest::distributions)).setter(UpdateDistributionConfigurationRequest.setter(Builder::distributions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Distribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateDistributionConfigurationRequest.getter(UpdateDistributionConfigurationRequest::clientToken)).setter(UpdateDistributionConfigurationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_CONFIGURATION_ARN_FIELD, DESCRIPTION_FIELD, DISTRIBUTIONS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("distributionConfigurationArn", DISTRIBUTION_CONFIGURATION_ARN_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("distributions", DISTRIBUTIONS_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final String distributionConfigurationArn;
    private final String description;
    private final List<Distribution> distributions;
    private final String clientToken;

    private UpdateDistributionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.distributionConfigurationArn = builder.distributionConfigurationArn;
        this.description = builder.description;
        this.distributions = builder.distributions;
        this.clientToken = builder.clientToken;
    }

    public final String distributionConfigurationArn() {
        return this.distributionConfigurationArn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasDistributions() {
        return this.distributions != null && !(this.distributions instanceof SdkAutoConstructList);
    }

    public final List<Distribution> distributions() {
        return this.distributions;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDistributions() ? this.distributions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDistributionConfigurationRequest)) {
            return false;
        }
        UpdateDistributionConfigurationRequest other = (UpdateDistributionConfigurationRequest)((Object)obj);
        return Objects.equals(this.distributionConfigurationArn(), other.distributionConfigurationArn()) && Objects.equals(this.description(), other.description()) && this.hasDistributions() == other.hasDistributions() && Objects.equals(this.distributions(), other.distributions()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDistributionConfigurationRequest").add("DistributionConfigurationArn", (Object)this.distributionConfigurationArn()).add("Description", (Object)this.description()).add("Distributions", this.hasDistributions() ? this.distributions() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "distributionConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.distributionConfigurationArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "distributions": {
                return Optional.ofNullable(clazz.cast(this.distributions()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDistributionConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateDistributionConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderRequest.BuilderImpl
    implements Builder {
        private String distributionConfigurationArn;
        private String description;
        private List<Distribution> distributions = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDistributionConfigurationRequest model) {
            super(model);
            this.distributionConfigurationArn(model.distributionConfigurationArn);
            this.description(model.description);
            this.distributions(model.distributions);
            this.clientToken(model.clientToken);
        }

        public final String getDistributionConfigurationArn() {
            return this.distributionConfigurationArn;
        }

        public final void setDistributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
        }

        @Override
        public final Builder distributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Distribution.Builder> getDistributions() {
            List<Distribution.Builder> result = DistributionListCopier.copyToBuilder(this.distributions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDistributions(Collection<Distribution.BuilderImpl> distributions) {
            this.distributions = DistributionListCopier.copyFromBuilder(distributions);
        }

        @Override
        public final Builder distributions(Collection<Distribution> distributions) {
            this.distributions = DistributionListCopier.copy(distributions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributions(Distribution ... distributions) {
            this.distributions(Arrays.asList(distributions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributions(Consumer<Distribution.Builder> ... distributions) {
            this.distributions(Stream.of(distributions).map(c -> (Distribution)((Distribution.Builder)Distribution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDistributionConfigurationRequest build() {
            return new UpdateDistributionConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ImagebuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDistributionConfigurationRequest> {
        public Builder distributionConfigurationArn(String var1);

        public Builder description(String var1);

        public Builder distributions(Collection<Distribution> var1);

        public Builder distributions(Distribution ... var1);

        public Builder distributions(Consumer<Distribution.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

