/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.TenancyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Placement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Placement> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(Placement.getter(Placement::availabilityZone)).setter(Placement.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tenancy").getter(Placement.getter(Placement::tenancyAsString)).setter(Placement.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenancy").build()}).build();
    private static final SdkField<String> HOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostId").getter(Placement.getter(Placement::hostId)).setter(Placement.setter(Builder::hostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostId").build()}).build();
    private static final SdkField<String> HOST_RESOURCE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostResourceGroupArn").getter(Placement.getter(Placement::hostResourceGroupArn)).setter(Placement.setter(Builder::hostResourceGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostResourceGroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, TENANCY_FIELD, HOST_ID_FIELD, HOST_RESOURCE_GROUP_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final String tenancy;
    private final String hostId;
    private final String hostResourceGroupArn;

    private Placement(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.tenancy = builder.tenancy;
        this.hostId = builder.hostId;
        this.hostResourceGroupArn = builder.hostResourceGroupArn;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final TenancyType tenancy() {
        return TenancyType.fromValue(this.tenancy);
    }

    public final String tenancyAsString() {
        return this.tenancy;
    }

    public final String hostId() {
        return this.hostId;
    }

    public final String hostResourceGroupArn() {
        return this.hostResourceGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostResourceGroupArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Placement)) {
            return false;
        }
        Placement other = (Placement)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && Objects.equals(this.hostId(), other.hostId()) && Objects.equals(this.hostResourceGroupArn(), other.hostResourceGroupArn());
    }

    public final String toString() {
        return ToString.builder((String)"Placement").add("AvailabilityZone", (Object)this.availabilityZone()).add("Tenancy", (Object)this.tenancyAsString()).add("HostId", (Object)this.hostId()).add("HostResourceGroupArn", (Object)this.hostResourceGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "hostId": {
                return Optional.ofNullable(clazz.cast(this.hostId()));
            }
            case "hostResourceGroupArn": {
                return Optional.ofNullable(clazz.cast(this.hostResourceGroupArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Placement, T> g) {
        return obj -> g.apply((Placement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String tenancy;
        private String hostId;
        private String hostResourceGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Placement model) {
            this.availabilityZone(model.availabilityZone);
            this.tenancy(model.tenancy);
            this.hostId(model.hostId);
            this.hostResourceGroupArn(model.hostResourceGroupArn);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(TenancyType tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final String getHostId() {
            return this.hostId;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final String getHostResourceGroupArn() {
            return this.hostResourceGroupArn;
        }

        public final void setHostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
        }

        @Override
        public final Builder hostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = hostResourceGroupArn;
            return this;
        }

        public Placement build() {
            return new Placement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Placement> {
        public Builder availabilityZone(String var1);

        public Builder tenancy(String var1);

        public Builder tenancy(TenancyType var1);

        public Builder hostId(String var1);

        public Builder hostResourceGroupArn(String var1);
    }
}

