/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.AccountAggregation;
import software.amazon.awssdk.services.imagebuilder.model.ImageAggregation;
import software.amazon.awssdk.services.imagebuilder.model.ImagePipelineAggregation;
import software.amazon.awssdk.services.imagebuilder.model.VulnerabilityIdAggregation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageScanFindingAggregation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageScanFindingAggregation> {
    private static final SdkField<AccountAggregation> ACCOUNT_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accountAggregation").getter(ImageScanFindingAggregation.getter(ImageScanFindingAggregation::accountAggregation)).setter(ImageScanFindingAggregation.setter(Builder::accountAggregation)).constructor(AccountAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountAggregation").build()}).build();
    private static final SdkField<ImageAggregation> IMAGE_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageAggregation").getter(ImageScanFindingAggregation.getter(ImageScanFindingAggregation::imageAggregation)).setter(ImageScanFindingAggregation.setter(Builder::imageAggregation)).constructor(ImageAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageAggregation").build()}).build();
    private static final SdkField<ImagePipelineAggregation> IMAGE_PIPELINE_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imagePipelineAggregation").getter(ImageScanFindingAggregation.getter(ImageScanFindingAggregation::imagePipelineAggregation)).setter(ImageScanFindingAggregation.setter(Builder::imagePipelineAggregation)).constructor(ImagePipelineAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePipelineAggregation").build()}).build();
    private static final SdkField<VulnerabilityIdAggregation> VULNERABILITY_ID_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vulnerabilityIdAggregation").getter(ImageScanFindingAggregation.getter(ImageScanFindingAggregation::vulnerabilityIdAggregation)).setter(ImageScanFindingAggregation.setter(Builder::vulnerabilityIdAggregation)).constructor(VulnerabilityIdAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilityIdAggregation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_AGGREGATION_FIELD, IMAGE_AGGREGATION_FIELD, IMAGE_PIPELINE_AGGREGATION_FIELD, VULNERABILITY_ID_AGGREGATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final AccountAggregation accountAggregation;
    private final ImageAggregation imageAggregation;
    private final ImagePipelineAggregation imagePipelineAggregation;
    private final VulnerabilityIdAggregation vulnerabilityIdAggregation;

    private ImageScanFindingAggregation(BuilderImpl builder) {
        this.accountAggregation = builder.accountAggregation;
        this.imageAggregation = builder.imageAggregation;
        this.imagePipelineAggregation = builder.imagePipelineAggregation;
        this.vulnerabilityIdAggregation = builder.vulnerabilityIdAggregation;
    }

    public final AccountAggregation accountAggregation() {
        return this.accountAggregation;
    }

    public final ImageAggregation imageAggregation() {
        return this.imageAggregation;
    }

    public final ImagePipelineAggregation imagePipelineAggregation() {
        return this.imagePipelineAggregation;
    }

    public final VulnerabilityIdAggregation vulnerabilityIdAggregation() {
        return this.vulnerabilityIdAggregation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePipelineAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.vulnerabilityIdAggregation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageScanFindingAggregation)) {
            return false;
        }
        ImageScanFindingAggregation other = (ImageScanFindingAggregation)obj;
        return Objects.equals(this.accountAggregation(), other.accountAggregation()) && Objects.equals(this.imageAggregation(), other.imageAggregation()) && Objects.equals(this.imagePipelineAggregation(), other.imagePipelineAggregation()) && Objects.equals(this.vulnerabilityIdAggregation(), other.vulnerabilityIdAggregation());
    }

    public final String toString() {
        return ToString.builder((String)"ImageScanFindingAggregation").add("AccountAggregation", (Object)this.accountAggregation()).add("ImageAggregation", (Object)this.imageAggregation()).add("ImagePipelineAggregation", (Object)this.imagePipelineAggregation()).add("VulnerabilityIdAggregation", (Object)this.vulnerabilityIdAggregation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountAggregation": {
                return Optional.ofNullable(clazz.cast(this.accountAggregation()));
            }
            case "imageAggregation": {
                return Optional.ofNullable(clazz.cast(this.imageAggregation()));
            }
            case "imagePipelineAggregation": {
                return Optional.ofNullable(clazz.cast(this.imagePipelineAggregation()));
            }
            case "vulnerabilityIdAggregation": {
                return Optional.ofNullable(clazz.cast(this.vulnerabilityIdAggregation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageScanFindingAggregation, T> g) {
        return obj -> g.apply((ImageScanFindingAggregation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AccountAggregation accountAggregation;
        private ImageAggregation imageAggregation;
        private ImagePipelineAggregation imagePipelineAggregation;
        private VulnerabilityIdAggregation vulnerabilityIdAggregation;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageScanFindingAggregation model) {
            this.accountAggregation(model.accountAggregation);
            this.imageAggregation(model.imageAggregation);
            this.imagePipelineAggregation(model.imagePipelineAggregation);
            this.vulnerabilityIdAggregation(model.vulnerabilityIdAggregation);
        }

        public final AccountAggregation.Builder getAccountAggregation() {
            return this.accountAggregation != null ? this.accountAggregation.toBuilder() : null;
        }

        public final void setAccountAggregation(AccountAggregation.BuilderImpl accountAggregation) {
            this.accountAggregation = accountAggregation != null ? accountAggregation.build() : null;
        }

        @Override
        public final Builder accountAggregation(AccountAggregation accountAggregation) {
            this.accountAggregation = accountAggregation;
            return this;
        }

        public final ImageAggregation.Builder getImageAggregation() {
            return this.imageAggregation != null ? this.imageAggregation.toBuilder() : null;
        }

        public final void setImageAggregation(ImageAggregation.BuilderImpl imageAggregation) {
            this.imageAggregation = imageAggregation != null ? imageAggregation.build() : null;
        }

        @Override
        public final Builder imageAggregation(ImageAggregation imageAggregation) {
            this.imageAggregation = imageAggregation;
            return this;
        }

        public final ImagePipelineAggregation.Builder getImagePipelineAggregation() {
            return this.imagePipelineAggregation != null ? this.imagePipelineAggregation.toBuilder() : null;
        }

        public final void setImagePipelineAggregation(ImagePipelineAggregation.BuilderImpl imagePipelineAggregation) {
            this.imagePipelineAggregation = imagePipelineAggregation != null ? imagePipelineAggregation.build() : null;
        }

        @Override
        public final Builder imagePipelineAggregation(ImagePipelineAggregation imagePipelineAggregation) {
            this.imagePipelineAggregation = imagePipelineAggregation;
            return this;
        }

        public final VulnerabilityIdAggregation.Builder getVulnerabilityIdAggregation() {
            return this.vulnerabilityIdAggregation != null ? this.vulnerabilityIdAggregation.toBuilder() : null;
        }

        public final void setVulnerabilityIdAggregation(VulnerabilityIdAggregation.BuilderImpl vulnerabilityIdAggregation) {
            this.vulnerabilityIdAggregation = vulnerabilityIdAggregation != null ? vulnerabilityIdAggregation.build() : null;
        }

        @Override
        public final Builder vulnerabilityIdAggregation(VulnerabilityIdAggregation vulnerabilityIdAggregation) {
            this.vulnerabilityIdAggregation = vulnerabilityIdAggregation;
            return this;
        }

        public ImageScanFindingAggregation build() {
            return new ImageScanFindingAggregation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageScanFindingAggregation> {
        public Builder accountAggregation(AccountAggregation var1);

        default public Builder accountAggregation(Consumer<AccountAggregation.Builder> accountAggregation) {
            return this.accountAggregation((AccountAggregation)((AccountAggregation.Builder)AccountAggregation.builder().applyMutation(accountAggregation)).build());
        }

        public Builder imageAggregation(ImageAggregation var1);

        default public Builder imageAggregation(Consumer<ImageAggregation.Builder> imageAggregation) {
            return this.imageAggregation((ImageAggregation)((ImageAggregation.Builder)ImageAggregation.builder().applyMutation(imageAggregation)).build());
        }

        public Builder imagePipelineAggregation(ImagePipelineAggregation var1);

        default public Builder imagePipelineAggregation(Consumer<ImagePipelineAggregation.Builder> imagePipelineAggregation) {
            return this.imagePipelineAggregation((ImagePipelineAggregation)((ImagePipelineAggregation.Builder)ImagePipelineAggregation.builder().applyMutation(imagePipelineAggregation)).build());
        }

        public Builder vulnerabilityIdAggregation(VulnerabilityIdAggregation var1);

        default public Builder vulnerabilityIdAggregation(Consumer<VulnerabilityIdAggregation.Builder> vulnerabilityIdAggregation) {
            return this.vulnerabilityIdAggregation((VulnerabilityIdAggregation)((VulnerabilityIdAggregation.Builder)VulnerabilityIdAggregation.builder().applyMutation(vulnerabilityIdAggregation)).build());
        }
    }
}

