/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.ContainerRecipeSummary;
import software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse;

public class ListContainerRecipesPublisher
implements SdkPublisher<ListContainerRecipesResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListContainerRecipesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContainerRecipesPublisher(ImagebuilderAsyncClient client, ListContainerRecipesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContainerRecipesPublisher(ImagebuilderAsyncClient client, ListContainerRecipesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContainerRecipesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContainerRecipesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContainerRecipeSummary> containerRecipeSummaryList() {
        Function<ListContainerRecipesResponse, Iterator> getIterator = response -> {
            if (response != null && response.containerRecipeSummaryList() != null) {
                return response.containerRecipeSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListContainerRecipesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListContainerRecipesResponseFetcher
    implements AsyncPageFetcher<ListContainerRecipesResponse> {
        private ListContainerRecipesResponseFetcher() {
        }

        public boolean hasNextPage(ListContainerRecipesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContainerRecipesResponse> nextPage(ListContainerRecipesResponse previousPage) {
            if (previousPage == null) {
                return ListContainerRecipesPublisher.this.client.listContainerRecipes(ListContainerRecipesPublisher.this.firstRequest);
            }
            return ListContainerRecipesPublisher.this.client.listContainerRecipes((ListContainerRecipesRequest)((Object)ListContainerRecipesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

