/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsResponse;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowStepMetadata;

public class ListWorkflowStepExecutionsPublisher
implements SdkPublisher<ListWorkflowStepExecutionsResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListWorkflowStepExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkflowStepExecutionsPublisher(ImagebuilderAsyncClient client, ListWorkflowStepExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkflowStepExecutionsPublisher(ImagebuilderAsyncClient client, ListWorkflowStepExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkflowStepExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkflowStepExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkflowStepMetadata> steps() {
        Function<ListWorkflowStepExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.steps() != null) {
                return response.steps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkflowStepExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkflowStepExecutionsResponseFetcher
    implements AsyncPageFetcher<ListWorkflowStepExecutionsResponse> {
        private ListWorkflowStepExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowStepExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkflowStepExecutionsResponse> nextPage(ListWorkflowStepExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowStepExecutionsPublisher.this.client.listWorkflowStepExecutions(ListWorkflowStepExecutionsPublisher.this.firstRequest);
            }
            return ListWorkflowStepExecutionsPublisher.this.client.listWorkflowStepExecutions((ListWorkflowStepExecutionsRequest)((Object)ListWorkflowStepExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

