/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DiskImageFormat {
    VMDK("VMDK"),
    RAW("RAW"),
    VHD("VHD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DiskImageFormat> VALUE_MAP;
    private final String value;

    private DiskImageFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DiskImageFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DiskImageFormat> knownValues() {
        EnumSet<DiskImageFormat> knownValues = EnumSet.allOf(DiskImageFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DiskImageFormat.class, DiskImageFormat::toString);
    }
}

