/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ComponentType;
import software.amazon.awssdk.services.imagebuilder.model.OsVersionListCopier;
import software.amazon.awssdk.services.imagebuilder.model.Platform;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentVersion> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ComponentVersion.getter(ComponentVersion::arn)).setter(ComponentVersion.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ComponentVersion.getter(ComponentVersion::name)).setter(ComponentVersion.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(ComponentVersion.getter(ComponentVersion::version)).setter(ComponentVersion.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ComponentVersion.getter(ComponentVersion::description)).setter(ComponentVersion.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(ComponentVersion.getter(ComponentVersion::platformAsString)).setter(ComponentVersion.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_OS_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedOsVersions").getter(ComponentVersion.getter(ComponentVersion::supportedOsVersions)).setter(ComponentVersion.setter(Builder::supportedOsVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedOsVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ComponentVersion.getter(ComponentVersion::typeAsString)).setter(ComponentVersion.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(ComponentVersion.getter(ComponentVersion::owner)).setter(ComponentVersion.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dateCreated").getter(ComponentVersion.getter(ComponentVersion::dateCreated)).setter(ComponentVersion.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, VERSION_FIELD, DESCRIPTION_FIELD, PLATFORM_FIELD, SUPPORTED_OS_VERSIONS_FIELD, TYPE_FIELD, OWNER_FIELD, DATE_CREATED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String version;
    private final String description;
    private final String platform;
    private final List<String> supportedOsVersions;
    private final String type;
    private final String owner;
    private final String dateCreated;

    private ComponentVersion(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.version = builder.version;
        this.description = builder.description;
        this.platform = builder.platform;
        this.supportedOsVersions = builder.supportedOsVersions;
        this.type = builder.type;
        this.owner = builder.owner;
        this.dateCreated = builder.dateCreated;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public String description() {
        return this.description;
    }

    public Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    public boolean hasSupportedOsVersions() {
        return this.supportedOsVersions != null && !(this.supportedOsVersions instanceof SdkAutoConstructList);
    }

    public List<String> supportedOsVersions() {
        return this.supportedOsVersions;
    }

    public ComponentType type() {
        return ComponentType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String owner() {
        return this.owner;
    }

    public String dateCreated() {
        return this.dateCreated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedOsVersions() ? this.supportedOsVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentVersion)) {
            return false;
        }
        ComponentVersion other = (ComponentVersion)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.platformAsString(), other.platformAsString()) && this.hasSupportedOsVersions() == other.hasSupportedOsVersions() && Objects.equals(this.supportedOsVersions(), other.supportedOsVersions()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.dateCreated(), other.dateCreated());
    }

    public String toString() {
        return ToString.builder((String)"ComponentVersion").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("Description", (Object)this.description()).add("Platform", (Object)this.platformAsString()).add("SupportedOsVersions", this.hasSupportedOsVersions() ? this.supportedOsVersions() : null).add("Type", (Object)this.typeAsString()).add("Owner", (Object)this.owner()).add("DateCreated", (Object)this.dateCreated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "supportedOsVersions": {
                return Optional.ofNullable(clazz.cast(this.supportedOsVersions()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "dateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentVersion, T> g) {
        return obj -> g.apply((ComponentVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String version;
        private String description;
        private String platform;
        private List<String> supportedOsVersions = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private String owner;
        private String dateCreated;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentVersion model) {
            this.arn(model.arn);
            this.name(model.name);
            this.version(model.version);
            this.description(model.description);
            this.platform(model.platform);
            this.supportedOsVersions(model.supportedOsVersions);
            this.type(model.type);
            this.owner(model.owner);
            this.dateCreated(model.dateCreated);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Collection<String> getSupportedOsVersions() {
            if (this.supportedOsVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedOsVersions;
        }

        @Override
        public final Builder supportedOsVersions(Collection<String> supportedOsVersions) {
            this.supportedOsVersions = OsVersionListCopier.copy(supportedOsVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedOsVersions(String ... supportedOsVersions) {
            this.supportedOsVersions(Arrays.asList(supportedOsVersions));
            return this;
        }

        public final void setSupportedOsVersions(Collection<String> supportedOsVersions) {
            this.supportedOsVersions = OsVersionListCopier.copy(supportedOsVersions);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ComponentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        public ComponentVersion build() {
            return new ComponentVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentVersion> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder version(String var1);

        public Builder description(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder supportedOsVersions(Collection<String> var1);

        public Builder supportedOsVersions(String ... var1);

        public Builder type(String var1);

        public Builder type(ComponentType var1);

        public Builder owner(String var1);

        public Builder dateCreated(String var1);
    }
}

