/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ImageRecipe;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetImageRecipeResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, GetImageRecipeResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(GetImageRecipeResponse.getter(GetImageRecipeResponse::requestId)).setter(GetImageRecipeResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<ImageRecipe> IMAGE_RECIPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageRecipe").getter(GetImageRecipeResponse.getter(GetImageRecipeResponse::imageRecipe)).setter(GetImageRecipeResponse.setter(Builder::imageRecipe)).constructor(ImageRecipe::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageRecipe").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, IMAGE_RECIPE_FIELD));
    private final String requestIdValue;
    private final ImageRecipe imageRecipe;

    private GetImageRecipeResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.imageRecipe = builder.imageRecipe;
    }

    public String requestId() {
        return this.requestIdValue;
    }

    public ImageRecipe imageRecipe() {
        return this.imageRecipe;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageRecipe());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImageRecipeResponse)) {
            return false;
        }
        GetImageRecipeResponse other = (GetImageRecipeResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.imageRecipe(), other.imageRecipe());
    }

    public String toString() {
        return ToString.builder((String)"GetImageRecipeResponse").add("RequestId", (Object)this.requestId()).add("ImageRecipe", (Object)this.imageRecipe()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "imageRecipe": {
                return Optional.ofNullable(clazz.cast(this.imageRecipe()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetImageRecipeResponse, T> g) {
        return obj -> g.apply((GetImageRecipeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private ImageRecipe imageRecipe;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImageRecipeResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.imageRecipe(model.imageRecipe);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final ImageRecipe.Builder getImageRecipe() {
            return this.imageRecipe != null ? this.imageRecipe.toBuilder() : null;
        }

        @Override
        public final Builder imageRecipe(ImageRecipe imageRecipe) {
            this.imageRecipe = imageRecipe;
            return this;
        }

        public final void setImageRecipe(ImageRecipe.BuilderImpl imageRecipe) {
            this.imageRecipe = imageRecipe != null ? imageRecipe.build() : null;
        }

        @Override
        public GetImageRecipeResponse build() {
            return new GetImageRecipeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetImageRecipeResponse> {
        public Builder requestId(String var1);

        public Builder imageRecipe(ImageRecipe var1);

        default public Builder imageRecipe(Consumer<ImageRecipe.Builder> imageRecipe) {
            return this.imageRecipe((ImageRecipe)((ImageRecipe.Builder)ImageRecipe.builder().applyMutation(imageRecipe)).build());
        }
    }
}

