/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderRequest;
import software.amazon.awssdk.services.imagebuilder.model.InstanceTypeListCopier;
import software.amazon.awssdk.services.imagebuilder.model.Logging;
import software.amazon.awssdk.services.imagebuilder.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInfrastructureConfigurationRequest
extends ImagebuilderRequest
implements ToCopyableBuilder<Builder, CreateInfrastructureConfigurationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::name)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::description)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::instanceTypes)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::instanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::instanceProfileName)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::instanceProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceProfileName").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::securityGroupIds)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::subnetId)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()}).build();
    private static final SdkField<Logging> LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::logging)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::logging)).constructor(Logging::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()}).build();
    private static final SdkField<String> KEY_PAIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::keyPair)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::keyPair)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPair").build()}).build();
    private static final SdkField<Boolean> TERMINATE_INSTANCE_ON_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::terminateInstanceOnFailure)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::terminateInstanceOnFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terminateInstanceOnFailure").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::snsTopicArn)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopicArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::tags)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInfrastructureConfigurationRequest.getter(CreateInfrastructureConfigurationRequest::clientToken)).setter(CreateInfrastructureConfigurationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, INSTANCE_TYPES_FIELD, INSTANCE_PROFILE_NAME_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_ID_FIELD, LOGGING_FIELD, KEY_PAIR_FIELD, TERMINATE_INSTANCE_ON_FAILURE_FIELD, SNS_TOPIC_ARN_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private final String name;
    private final String description;
    private final List<String> instanceTypes;
    private final String instanceProfileName;
    private final List<String> securityGroupIds;
    private final String subnetId;
    private final Logging logging;
    private final String keyPair;
    private final Boolean terminateInstanceOnFailure;
    private final String snsTopicArn;
    private final Map<String, String> tags;
    private final String clientToken;

    private CreateInfrastructureConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.instanceTypes = builder.instanceTypes;
        this.instanceProfileName = builder.instanceProfileName;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.logging = builder.logging;
        this.keyPair = builder.keyPair;
        this.terminateInstanceOnFailure = builder.terminateInstanceOnFailure;
        this.snsTopicArn = builder.snsTopicArn;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public boolean hasInstanceTypes() {
        return this.instanceTypes != null && !(this.instanceTypes instanceof SdkAutoConstructList);
    }

    public List<String> instanceTypes() {
        return this.instanceTypes;
    }

    public String instanceProfileName() {
        return this.instanceProfileName;
    }

    public boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public Logging logging() {
        return this.logging;
    }

    public String keyPair() {
        return this.keyPair;
    }

    public Boolean terminateInstanceOnFailure() {
        return this.terminateInstanceOnFailure;
    }

    public String snsTopicArn() {
        return this.snsTopicArn;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logging());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPair());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateInstanceOnFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInfrastructureConfigurationRequest)) {
            return false;
        }
        CreateInfrastructureConfigurationRequest other = (CreateInfrastructureConfigurationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.instanceTypes(), other.instanceTypes()) && Objects.equals(this.instanceProfileName(), other.instanceProfileName()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.logging(), other.logging()) && Objects.equals(this.keyPair(), other.keyPair()) && Objects.equals(this.terminateInstanceOnFailure(), other.terminateInstanceOnFailure()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateInfrastructureConfigurationRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("InstanceTypes", this.instanceTypes()).add("InstanceProfileName", (Object)this.instanceProfileName()).add("SecurityGroupIds", this.securityGroupIds()).add("SubnetId", (Object)this.subnetId()).add("Logging", (Object)this.logging()).add("KeyPair", (Object)this.keyPair()).add("TerminateInstanceOnFailure", (Object)this.terminateInstanceOnFailure()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("Tags", this.tags()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "instanceTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceTypes()));
            }
            case "instanceProfileName": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileName()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "subnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "logging": {
                return Optional.ofNullable(clazz.cast(this.logging()));
            }
            case "keyPair": {
                return Optional.ofNullable(clazz.cast(this.keyPair()));
            }
            case "terminateInstanceOnFailure": {
                return Optional.ofNullable(clazz.cast(this.terminateInstanceOnFailure()));
            }
            case "snsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInfrastructureConfigurationRequest, T> g) {
        return obj -> g.apply((CreateInfrastructureConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();
        private String instanceProfileName;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String subnetId;
        private Logging logging;
        private String keyPair;
        private Boolean terminateInstanceOnFailure;
        private String snsTopicArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInfrastructureConfigurationRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.instanceTypes(model.instanceTypes);
            this.instanceProfileName(model.instanceProfileName);
            this.securityGroupIds(model.securityGroupIds);
            this.subnetId(model.subnetId);
            this.logging(model.logging);
            this.keyPair(model.keyPair);
            this.terminateInstanceOnFailure(model.terminateInstanceOnFailure);
            this.snsTopicArn(model.snsTopicArn);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getInstanceTypes() {
            return this.instanceTypes;
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
        }

        public final String getInstanceProfileName() {
            return this.instanceProfileName;
        }

        @Override
        public final Builder instanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        public final void setInstanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Logging.Builder getLogging() {
            return this.logging != null ? this.logging.toBuilder() : null;
        }

        @Override
        public final Builder logging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public final void setLogging(Logging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        public final String getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        public final Boolean getTerminateInstanceOnFailure() {
            return this.terminateInstanceOnFailure;
        }

        @Override
        public final Builder terminateInstanceOnFailure(Boolean terminateInstanceOnFailure) {
            this.terminateInstanceOnFailure = terminateInstanceOnFailure;
            return this;
        }

        public final void setTerminateInstanceOnFailure(Boolean terminateInstanceOnFailure) {
            this.terminateInstanceOnFailure = terminateInstanceOnFailure;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInfrastructureConfigurationRequest build() {
            return new CreateInfrastructureConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInfrastructureConfigurationRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder instanceTypes(Collection<String> var1);

        public Builder instanceTypes(String ... var1);

        public Builder instanceProfileName(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetId(String var1);

        public Builder logging(Logging var1);

        default public Builder logging(Consumer<Logging.Builder> logging) {
            return this.logging((Logging)((Logging.Builder)Logging.builder().applyMutation(logging)).build());
        }

        public Builder keyPair(String var1);

        public Builder terminateInstanceOnFailure(Boolean var1);

        public Builder snsTopicArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

