/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that a requested resource is not found.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceNotFoundException extends IdentitystoreException implements
        ToCopyableBuilder<ResourceNotFoundException.Builder, ResourceNotFoundException> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ResourceNotFoundException::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ResourceNotFoundException::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(ResourceNotFoundException::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(ResourceNotFoundException::requestIdValue))
            .setter(setter(Builder::requestIdValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            RESOURCE_ID_FIELD, REASON_FIELD, REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final String resourceId;

    private final String reason;

    private final String requestId;

    private ResourceNotFoundException(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.reason = builder.reason;
        this.requestId = builder.requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * An enum object indicating the type of resource in the identity store service. Valid values include USER, GROUP,
     * and IDENTITY_STORE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return An enum object indicating the type of resource in the identity store service. Valid values include USER,
     *         GROUP, and IDENTITY_STORE.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * An enum object indicating the type of resource in the identity store service. Valid values include USER, GROUP,
     * and IDENTITY_STORE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return An enum object indicating the type of resource in the identity store service. Valid values include USER,
     *         GROUP, and IDENTITY_STORE.
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The identifier for a resource in the identity store that can be used as <code>UserId</code> or
     * <code>GroupId</code>. The format for <code>ResourceId</code> is either <code>UUID</code> or
     * <code>1234567890-UUID</code>, where <code>UUID</code> is a randomly generated value for each resource when it is
     * created and <code>1234567890</code> represents the <code> IdentityStoreId</code> string value. In the case that
     * the identity store is migrated from a legacy SSO identity store, the <code>ResourceId</code> for that identity
     * store will be in the format of <code>UUID</code>. Otherwise, it will be in the <code>1234567890-UUID</code>
     * format.
     * </p>
     * 
     * @return The identifier for a resource in the identity store that can be used as <code>UserId</code> or
     *         <code>GroupId</code>. The format for <code>ResourceId</code> is either <code>UUID</code> or
     *         <code>1234567890-UUID</code>, where <code>UUID</code> is a randomly generated value for each resource
     *         when it is created and <code>1234567890</code> represents the <code> IdentityStoreId</code> string value.
     *         In the case that the identity store is migrated from a legacy SSO identity store, the
     *         <code>ResourceId</code> for that identity store will be in the format of <code>UUID</code>. Otherwise, it
     *         will be in the <code>1234567890-UUID</code> format.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Indicates the reason for a resource not found error when the service is unable to access a Customer Managed KMS
     * key. For non-KMS permission errors, this field is not included.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ResourceNotFoundExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return Indicates the reason for a resource not found error when the service is unable to access a Customer
     *         Managed KMS key. For non-KMS permission errors, this field is not included.
     * @see ResourceNotFoundExceptionReason
     */
    public ResourceNotFoundExceptionReason reason() {
        return ResourceNotFoundExceptionReason.fromValue(reason);
    }

    /**
     * <p>
     * Indicates the reason for a resource not found error when the service is unable to access a Customer Managed KMS
     * key. For non-KMS permission errors, this field is not included.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ResourceNotFoundExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return Indicates the reason for a resource not found error when the service is unable to access a Customer
     *         Managed KMS key. For non-KMS permission errors, this field is not included.
     * @see ResourceNotFoundExceptionReason
     */
    public String reasonAsString() {
        return reason;
    }

    /**
     * <p>
     * The identifier for each request. This value is a globally unique ID that is generated by the identity store
     * service for each sent request, and is then returned inside the exception if the request fails.
     * </p>
     * 
     * @return The identifier for each request. This value is a globally unique ID that is generated by the identity
     *         store service for each sent request, and is then returned inside the exception if the request fails.
     */
    public String requestIdValue() {
        return requestId;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("Reason", REASON_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceNotFoundException, T> g) {
        return obj -> g.apply((ResourceNotFoundException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceNotFoundException>, IdentitystoreException.Builder {
        /**
         * <p>
         * An enum object indicating the type of resource in the identity store service. Valid values include USER,
         * GROUP, and IDENTITY_STORE.
         * </p>
         * 
         * @param resourceType
         *        An enum object indicating the type of resource in the identity store service. Valid values include
         *        USER, GROUP, and IDENTITY_STORE.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * An enum object indicating the type of resource in the identity store service. Valid values include USER,
         * GROUP, and IDENTITY_STORE.
         * </p>
         * 
         * @param resourceType
         *        An enum object indicating the type of resource in the identity store service. Valid values include
         *        USER, GROUP, and IDENTITY_STORE.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The identifier for a resource in the identity store that can be used as <code>UserId</code> or
         * <code>GroupId</code>. The format for <code>ResourceId</code> is either <code>UUID</code> or
         * <code>1234567890-UUID</code>, where <code>UUID</code> is a randomly generated value for each resource when it
         * is created and <code>1234567890</code> represents the <code> IdentityStoreId</code> string value. In the case
         * that the identity store is migrated from a legacy SSO identity store, the <code>ResourceId</code> for that
         * identity store will be in the format of <code>UUID</code>. Otherwise, it will be in the
         * <code>1234567890-UUID</code> format.
         * </p>
         * 
         * @param resourceId
         *        The identifier for a resource in the identity store that can be used as <code>UserId</code> or
         *        <code>GroupId</code>. The format for <code>ResourceId</code> is either <code>UUID</code> or
         *        <code>1234567890-UUID</code>, where <code>UUID</code> is a randomly generated value for each resource
         *        when it is created and <code>1234567890</code> represents the <code> IdentityStoreId</code> string
         *        value. In the case that the identity store is migrated from a legacy SSO identity store, the
         *        <code>ResourceId</code> for that identity store will be in the format of <code>UUID</code>. Otherwise,
         *        it will be in the <code>1234567890-UUID</code> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Indicates the reason for a resource not found error when the service is unable to access a Customer Managed
         * KMS key. For non-KMS permission errors, this field is not included.
         * </p>
         * 
         * @param reason
         *        Indicates the reason for a resource not found error when the service is unable to access a Customer
         *        Managed KMS key. For non-KMS permission errors, this field is not included.
         * @see ResourceNotFoundExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceNotFoundExceptionReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * Indicates the reason for a resource not found error when the service is unable to access a Customer Managed
         * KMS key. For non-KMS permission errors, this field is not included.
         * </p>
         * 
         * @param reason
         *        Indicates the reason for a resource not found error when the service is unable to access a Customer
         *        Managed KMS key. For non-KMS permission errors, this field is not included.
         * @see ResourceNotFoundExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceNotFoundExceptionReason
         */
        Builder reason(ResourceNotFoundExceptionReason reason);

        /**
         * <p>
         * The identifier for each request. This value is a globally unique ID that is generated by the identity store
         * service for each sent request, and is then returned inside the exception if the request fails.
         * </p>
         * 
         * @param requestId
         *        The identifier for each request. This value is a globally unique ID that is generated by the identity
         *        store service for each sent request, and is then returned inside the exception if the request fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestIdValue(String requestId);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);

        @Override
        Builder numAttempts(Integer numAttempts);
    }

    static final class BuilderImpl extends IdentitystoreException.BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private String reason;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceNotFoundException model) {
            super(model);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            reason(model.reason);
            requestIdValue(model.requestId);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ResourceNotFoundExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getRequestIdValue() {
            return requestId;
        }

        public final void setRequestIdValue(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestIdValue(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public ResourceNotFoundException build() {
            return new ResourceNotFoundException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
