/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.identitystore.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.identitystore.IdentitystoreClient;
import software.amazon.awssdk.services.identitystore.model.GroupMembership;
import software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberRequest;
import software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberResponse;

public class ListGroupMembershipsForMemberIterable
implements SdkIterable<ListGroupMembershipsForMemberResponse> {
    private final IdentitystoreClient client;
    private final ListGroupMembershipsForMemberRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupMembershipsForMemberIterable(IdentitystoreClient client, ListGroupMembershipsForMemberRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGroupMembershipsForMemberResponseFetcher();
    }

    public Iterator<ListGroupMembershipsForMemberResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GroupMembership> groupMemberships() {
        Function<ListGroupMembershipsForMemberResponse, Iterator> getIterator = response -> {
            if (response != null && response.groupMemberships() != null) {
                return response.groupMemberships().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGroupMembershipsForMemberResponseFetcher
    implements SyncPageFetcher<ListGroupMembershipsForMemberResponse> {
        private ListGroupMembershipsForMemberResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupMembershipsForMemberResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGroupMembershipsForMemberResponse nextPage(ListGroupMembershipsForMemberResponse previousPage) {
            if (previousPage == null) {
                return ListGroupMembershipsForMemberIterable.this.client.listGroupMembershipsForMember(ListGroupMembershipsForMemberIterable.this.firstRequest);
            }
            return ListGroupMembershipsForMemberIterable.this.client.listGroupMembershipsForMember((ListGroupMembershipsForMemberRequest)((Object)ListGroupMembershipsForMemberIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

