/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.EntityDetails;
import software.amazon.awssdk.services.iam.model.ErrorDetails;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.JobStatusType;
import software.amazon.awssdk.services.iam.model._entityDetailsListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetServiceLastAccessedDetailsWithEntitiesResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetServiceLastAccessedDetailsWithEntitiesResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetServiceLastAccessedDetailsWithEntitiesResponse.getter(GetServiceLastAccessedDetailsWithEntitiesResponse::jobStatusAsString)).setter(GetServiceLastAccessedDetailsWithEntitiesResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<Instant> JOB_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetServiceLastAccessedDetailsWithEntitiesResponse.getter(GetServiceLastAccessedDetailsWithEntitiesResponse::jobCreationDate)).setter(GetServiceLastAccessedDetailsWithEntitiesResponse.setter(Builder::jobCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobCreationDate").build()}).build();
    private static final SdkField<Instant> JOB_COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetServiceLastAccessedDetailsWithEntitiesResponse.getter(GetServiceLastAccessedDetailsWithEntitiesResponse::jobCompletionDate)).setter(GetServiceLastAccessedDetailsWithEntitiesResponse.setter(Builder::jobCompletionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobCompletionDate").build()}).build();
    private static final SdkField<List<EntityDetails>> ENTITY_DETAILS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetServiceLastAccessedDetailsWithEntitiesResponse.getter(GetServiceLastAccessedDetailsWithEntitiesResponse::entityDetailsList)).setter(GetServiceLastAccessedDetailsWithEntitiesResponse.setter(Builder::entityDetailsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityDetailsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GetServiceLastAccessedDetailsWithEntitiesResponse.getter(GetServiceLastAccessedDetailsWithEntitiesResponse::isTruncated)).setter(GetServiceLastAccessedDetailsWithEntitiesResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetServiceLastAccessedDetailsWithEntitiesResponse.getter(GetServiceLastAccessedDetailsWithEntitiesResponse::marker)).setter(GetServiceLastAccessedDetailsWithEntitiesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<ErrorDetails> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetServiceLastAccessedDetailsWithEntitiesResponse.getter(GetServiceLastAccessedDetailsWithEntitiesResponse::error)).setter(GetServiceLastAccessedDetailsWithEntitiesResponse.setter(Builder::error)).constructor(ErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD, JOB_CREATION_DATE_FIELD, JOB_COMPLETION_DATE_FIELD, ENTITY_DETAILS_LIST_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD, ERROR_FIELD));
    private final String jobStatus;
    private final Instant jobCreationDate;
    private final Instant jobCompletionDate;
    private final List<EntityDetails> entityDetailsList;
    private final Boolean isTruncated;
    private final String marker;
    private final ErrorDetails error;

    private GetServiceLastAccessedDetailsWithEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.jobCreationDate = builder.jobCreationDate;
        this.jobCompletionDate = builder.jobCompletionDate;
        this.entityDetailsList = builder.entityDetailsList;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
        this.error = builder.error;
    }

    public JobStatusType jobStatus() {
        return JobStatusType.fromValue(this.jobStatus);
    }

    public String jobStatusAsString() {
        return this.jobStatus;
    }

    public Instant jobCreationDate() {
        return this.jobCreationDate;
    }

    public Instant jobCompletionDate() {
        return this.jobCompletionDate;
    }

    public List<EntityDetails> entityDetailsList() {
        return this.entityDetailsList;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public ErrorDetails error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobCompletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityDetailsList());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceLastAccessedDetailsWithEntitiesResponse)) {
            return false;
        }
        GetServiceLastAccessedDetailsWithEntitiesResponse other = (GetServiceLastAccessedDetailsWithEntitiesResponse)((Object)obj);
        return Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.jobCreationDate(), other.jobCreationDate()) && Objects.equals(this.jobCompletionDate(), other.jobCompletionDate()) && Objects.equals(this.entityDetailsList(), other.entityDetailsList()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.error(), other.error());
    }

    public String toString() {
        return ToString.builder((String)"GetServiceLastAccessedDetailsWithEntitiesResponse").add("JobStatus", (Object)this.jobStatusAsString()).add("JobCreationDate", (Object)this.jobCreationDate()).add("JobCompletionDate", (Object)this.jobCompletionDate()).add("EntityDetailsList", this.entityDetailsList()).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).add("Error", (Object)this.error()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "JobCreationDate": {
                return Optional.ofNullable(clazz.cast(this.jobCreationDate()));
            }
            case "JobCompletionDate": {
                return Optional.ofNullable(clazz.cast(this.jobCompletionDate()));
            }
            case "EntityDetailsList": {
                return Optional.ofNullable(clazz.cast(this.entityDetailsList()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceLastAccessedDetailsWithEntitiesResponse, T> g) {
        return obj -> g.apply((GetServiceLastAccessedDetailsWithEntitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private String jobStatus;
        private Instant jobCreationDate;
        private Instant jobCompletionDate;
        private List<EntityDetails> entityDetailsList = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;
        private ErrorDetails error;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceLastAccessedDetailsWithEntitiesResponse model) {
            super(model);
            this.jobStatus(model.jobStatus);
            this.jobCreationDate(model.jobCreationDate);
            this.jobCompletionDate(model.jobCompletionDate);
            this.entityDetailsList(model.entityDetailsList);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
            this.error(model.error);
        }

        public final String getJobStatusAsString() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatusType jobStatus) {
            this.jobStatus(jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final Instant getJobCreationDate() {
            return this.jobCreationDate;
        }

        @Override
        public final Builder jobCreationDate(Instant jobCreationDate) {
            this.jobCreationDate = jobCreationDate;
            return this;
        }

        public final void setJobCreationDate(Instant jobCreationDate) {
            this.jobCreationDate = jobCreationDate;
        }

        public final Instant getJobCompletionDate() {
            return this.jobCompletionDate;
        }

        @Override
        public final Builder jobCompletionDate(Instant jobCompletionDate) {
            this.jobCompletionDate = jobCompletionDate;
            return this;
        }

        public final void setJobCompletionDate(Instant jobCompletionDate) {
            this.jobCompletionDate = jobCompletionDate;
        }

        public final Collection<EntityDetails.Builder> getEntityDetailsList() {
            return this.entityDetailsList != null ? (Collection)this.entityDetailsList.stream().map(EntityDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entityDetailsList(Collection<EntityDetails> entityDetailsList) {
            this.entityDetailsList = _entityDetailsListTypeCopier.copy(entityDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityDetailsList(EntityDetails ... entityDetailsList) {
            this.entityDetailsList(Arrays.asList(entityDetailsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityDetailsList(Consumer<EntityDetails.Builder> ... entityDetailsList) {
            this.entityDetailsList(Stream.of(entityDetailsList).map(c -> (EntityDetails)((EntityDetails.Builder)EntityDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntityDetailsList(Collection<EntityDetails.BuilderImpl> entityDetailsList) {
            this.entityDetailsList = _entityDetailsListTypeCopier.copyFromBuilder(entityDetailsList);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final ErrorDetails.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        @Override
        public final Builder error(ErrorDetails error) {
            this.error = error;
            return this;
        }

        public final void setError(ErrorDetails.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public GetServiceLastAccessedDetailsWithEntitiesResponse build() {
            return new GetServiceLastAccessedDetailsWithEntitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetServiceLastAccessedDetailsWithEntitiesResponse> {
        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatusType var1);

        public Builder jobCreationDate(Instant var1);

        public Builder jobCompletionDate(Instant var1);

        public Builder entityDetailsList(Collection<EntityDetails> var1);

        public Builder entityDetailsList(EntityDetails ... var1);

        public Builder entityDetailsList(Consumer<EntityDetails.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);

        public Builder error(ErrorDetails var1);

        default public Builder error(Consumer<ErrorDetails.Builder> error) {
            return this.error((ErrorDetails)((ErrorDetails.Builder)ErrorDetails.builder().applyMutation(error)).build());
        }
    }
}

