/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableOutboundWebIdentityFederationResponse
extends IamResponse
implements ToCopyableBuilder<Builder, EnableOutboundWebIdentityFederationResponse> {
    private static final SdkField<String> ISSUER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IssuerIdentifier").getter(EnableOutboundWebIdentityFederationResponse.getter(EnableOutboundWebIdentityFederationResponse::issuerIdentifier)).setter(EnableOutboundWebIdentityFederationResponse.setter(Builder::issuerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuerIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUER_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnableOutboundWebIdentityFederationResponse.memberNameToFieldInitializer();
    private final String issuerIdentifier;

    private EnableOutboundWebIdentityFederationResponse(BuilderImpl builder) {
        super(builder);
        this.issuerIdentifier = builder.issuerIdentifier;
    }

    public final String issuerIdentifier() {
        return this.issuerIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.issuerIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableOutboundWebIdentityFederationResponse)) {
            return false;
        }
        EnableOutboundWebIdentityFederationResponse other = (EnableOutboundWebIdentityFederationResponse)((Object)obj);
        return Objects.equals(this.issuerIdentifier(), other.issuerIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"EnableOutboundWebIdentityFederationResponse").add("IssuerIdentifier", (Object)this.issuerIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IssuerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.issuerIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("IssuerIdentifier", ISSUER_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableOutboundWebIdentityFederationResponse, T> g) {
        return obj -> g.apply((EnableOutboundWebIdentityFederationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private String issuerIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableOutboundWebIdentityFederationResponse model) {
            super(model);
            this.issuerIdentifier(model.issuerIdentifier);
        }

        public final String getIssuerIdentifier() {
            return this.issuerIdentifier;
        }

        public final void setIssuerIdentifier(String issuerIdentifier) {
            this.issuerIdentifier = issuerIdentifier;
        }

        @Override
        public final Builder issuerIdentifier(String issuerIdentifier) {
            this.issuerIdentifier = issuerIdentifier;
            return this;
        }

        @Override
        public EnableOutboundWebIdentityFederationResponse build() {
            return new EnableOutboundWebIdentityFederationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableOutboundWebIdentityFederationResponse> {
        public Builder issuerIdentifier(String var1);
    }
}

