/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.model.ListRolesRequest;
import software.amazon.awssdk.services.iam.model.ListRolesResponse;
import software.amazon.awssdk.services.iam.model.Role;

public class ListRolesIterable
implements SdkIterable<ListRolesResponse> {
    private final IamClient client;
    private final ListRolesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRolesIterable(IamClient client, ListRolesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRolesResponseFetcher();
    }

    public Iterator<ListRolesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Role> roles() {
        Function<ListRolesResponse, Iterator> getIterator = response -> {
            if (response != null && response.roles() != null) {
                return response.roles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListRolesIterable resume(ListRolesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListRolesIterable(this.client, (ListRolesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListRolesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListRolesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListRolesResponseFetcher
    implements SyncPageFetcher<ListRolesResponse> {
        private ListRolesResponseFetcher() {
        }

        public boolean hasNextPage(ListRolesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListRolesResponse nextPage(ListRolesResponse previousPage) {
            if (previousPage == null) {
                return ListRolesIterable.this.client.listRoles(ListRolesIterable.this.firstRequest);
            }
            return ListRolesIterable.this.client.listRoles((ListRolesRequest)((Object)ListRolesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

