/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOutboundWebIdentityFederationInfoResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetOutboundWebIdentityFederationInfoResponse> {
    private static final SdkField<String> ISSUER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IssuerIdentifier").getter(GetOutboundWebIdentityFederationInfoResponse.getter(GetOutboundWebIdentityFederationInfoResponse::issuerIdentifier)).setter(GetOutboundWebIdentityFederationInfoResponse.setter(Builder::issuerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuerIdentifier").build()}).build();
    private static final SdkField<Boolean> JWT_VENDING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("JwtVendingEnabled").getter(GetOutboundWebIdentityFederationInfoResponse.getter(GetOutboundWebIdentityFederationInfoResponse::jwtVendingEnabled)).setter(GetOutboundWebIdentityFederationInfoResponse.setter(Builder::jwtVendingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JwtVendingEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUER_IDENTIFIER_FIELD, JWT_VENDING_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOutboundWebIdentityFederationInfoResponse.memberNameToFieldInitializer();
    private final String issuerIdentifier;
    private final Boolean jwtVendingEnabled;

    private GetOutboundWebIdentityFederationInfoResponse(BuilderImpl builder) {
        super(builder);
        this.issuerIdentifier = builder.issuerIdentifier;
        this.jwtVendingEnabled = builder.jwtVendingEnabled;
    }

    public final String issuerIdentifier() {
        return this.issuerIdentifier;
    }

    public final Boolean jwtVendingEnabled() {
        return this.jwtVendingEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.issuerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.jwtVendingEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOutboundWebIdentityFederationInfoResponse)) {
            return false;
        }
        GetOutboundWebIdentityFederationInfoResponse other = (GetOutboundWebIdentityFederationInfoResponse)((Object)obj);
        return Objects.equals(this.issuerIdentifier(), other.issuerIdentifier()) && Objects.equals(this.jwtVendingEnabled(), other.jwtVendingEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"GetOutboundWebIdentityFederationInfoResponse").add("IssuerIdentifier", (Object)this.issuerIdentifier()).add("JwtVendingEnabled", (Object)this.jwtVendingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IssuerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.issuerIdentifier()));
            }
            case "JwtVendingEnabled": {
                return Optional.ofNullable(clazz.cast(this.jwtVendingEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IssuerIdentifier", ISSUER_IDENTIFIER_FIELD);
        map.put("JwtVendingEnabled", JWT_VENDING_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOutboundWebIdentityFederationInfoResponse, T> g) {
        return obj -> g.apply((GetOutboundWebIdentityFederationInfoResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private String issuerIdentifier;
        private Boolean jwtVendingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOutboundWebIdentityFederationInfoResponse model) {
            super(model);
            this.issuerIdentifier(model.issuerIdentifier);
            this.jwtVendingEnabled(model.jwtVendingEnabled);
        }

        public final String getIssuerIdentifier() {
            return this.issuerIdentifier;
        }

        public final void setIssuerIdentifier(String issuerIdentifier) {
            this.issuerIdentifier = issuerIdentifier;
        }

        @Override
        public final Builder issuerIdentifier(String issuerIdentifier) {
            this.issuerIdentifier = issuerIdentifier;
            return this;
        }

        public final Boolean getJwtVendingEnabled() {
            return this.jwtVendingEnabled;
        }

        public final void setJwtVendingEnabled(Boolean jwtVendingEnabled) {
            this.jwtVendingEnabled = jwtVendingEnabled;
        }

        @Override
        public final Builder jwtVendingEnabled(Boolean jwtVendingEnabled) {
            this.jwtVendingEnabled = jwtVendingEnabled;
            return this;
        }

        @Override
        public GetOutboundWebIdentityFederationInfoResponse build() {
            return new GetOutboundWebIdentityFederationInfoResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOutboundWebIdentityFederationInfoResponse> {
        public Builder issuerIdentifier(String var1);

        public Builder jwtVendingEnabled(Boolean var1);
    }
}

