/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a
 * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetContextKeysForPrincipalPolicy.html"
 * >GetContextKeysForPrincipalPolicy</a> or <a
 * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetContextKeysForCustomPolicy.html"
 * >GetContextKeysForCustomPolicy</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContextKeysForCustomPolicyResponse extends IamResponse implements
        ToCopyableBuilder<GetContextKeysForCustomPolicyResponse.Builder, GetContextKeysForCustomPolicyResponse> {
    private static final SdkField<List<String>> CONTEXT_KEY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContextKeyNames")
            .getter(getter(GetContextKeysForCustomPolicyResponse::contextKeyNames))
            .setter(setter(Builder::contextKeyNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextKeyNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_KEY_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> contextKeyNames;

    private GetContextKeysForCustomPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.contextKeyNames = builder.contextKeyNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContextKeyNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContextKeyNames() {
        return contextKeyNames != null && !(contextKeyNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of context keys that are referenced in the input policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContextKeyNames} method.
     * </p>
     * 
     * @return The list of context keys that are referenced in the input policies.
     */
    public final List<String> contextKeyNames() {
        return contextKeyNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasContextKeyNames() ? contextKeyNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContextKeysForCustomPolicyResponse)) {
            return false;
        }
        GetContextKeysForCustomPolicyResponse other = (GetContextKeysForCustomPolicyResponse) obj;
        return hasContextKeyNames() == other.hasContextKeyNames() && Objects.equals(contextKeyNames(), other.contextKeyNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetContextKeysForCustomPolicyResponse")
                .add("ContextKeyNames", hasContextKeyNames() ? contextKeyNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContextKeyNames":
            return Optional.ofNullable(clazz.cast(contextKeyNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContextKeyNames", CONTEXT_KEY_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetContextKeysForCustomPolicyResponse, T> g) {
        return obj -> g.apply((GetContextKeysForCustomPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetContextKeysForCustomPolicyResponse> {
        /**
         * <p>
         * The list of context keys that are referenced in the input policies.
         * </p>
         * 
         * @param contextKeyNames
         *        The list of context keys that are referenced in the input policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextKeyNames(Collection<String> contextKeyNames);

        /**
         * <p>
         * The list of context keys that are referenced in the input policies.
         * </p>
         * 
         * @param contextKeyNames
         *        The list of context keys that are referenced in the input policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextKeyNames(String... contextKeyNames);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private List<String> contextKeyNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContextKeysForCustomPolicyResponse model) {
            super(model);
            contextKeyNames(model.contextKeyNames);
        }

        public final Collection<String> getContextKeyNames() {
            if (contextKeyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return contextKeyNames;
        }

        public final void setContextKeyNames(Collection<String> contextKeyNames) {
            this.contextKeyNames = ContextKeyNamesResultListTypeCopier.copy(contextKeyNames);
        }

        @Override
        public final Builder contextKeyNames(Collection<String> contextKeyNames) {
            this.contextKeyNames = ContextKeyNamesResultListTypeCopier.copy(contextKeyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextKeyNames(String... contextKeyNames) {
            contextKeyNames(Arrays.asList(contextKeyNames));
            return this;
        }

        @Override
        public GetContextKeysForCustomPolicyResponse build() {
            return new GetContextKeysForCustomPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
