/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.MFADevice;
import software.amazon.awssdk.services.iam.model._mfaDeviceListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMfaDevicesResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListMfaDevicesResponse> {
    private static final SdkField<List<MFADevice>> MFA_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MFADevices").getter(ListMfaDevicesResponse.getter(ListMfaDevicesResponse::mfaDevices)).setter(ListMfaDevicesResponse.setter(Builder::mfaDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MFADevices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MFADevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(ListMfaDevicesResponse.getter(ListMfaDevicesResponse::isTruncated)).setter(ListMfaDevicesResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListMfaDevicesResponse.getter(ListMfaDevicesResponse::marker)).setter(ListMfaDevicesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MFA_DEVICES_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMfaDevicesResponse.memberNameToFieldInitializer();
    private final List<MFADevice> mfaDevices;
    private final Boolean isTruncated;
    private final String marker;

    private ListMfaDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.mfaDevices = builder.mfaDevices;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public final boolean hasMfaDevices() {
        return this.mfaDevices != null && !(this.mfaDevices instanceof SdkAutoConstructList);
    }

    public final List<MFADevice> mfaDevices() {
        return this.mfaDevices;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMfaDevices() ? this.mfaDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMfaDevicesResponse)) {
            return false;
        }
        ListMfaDevicesResponse other = (ListMfaDevicesResponse)((Object)obj);
        return this.hasMfaDevices() == other.hasMfaDevices() && Objects.equals(this.mfaDevices(), other.mfaDevices()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListMfaDevicesResponse").add("MFADevices", this.hasMfaDevices() ? this.mfaDevices() : null).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MFADevices": {
                return Optional.ofNullable(clazz.cast(this.mfaDevices()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MFADevices", MFA_DEVICES_FIELD);
        map.put("IsTruncated", IS_TRUNCATED_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMfaDevicesResponse, T> g) {
        return obj -> g.apply((ListMfaDevicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<MFADevice> mfaDevices = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMfaDevicesResponse model) {
            super(model);
            this.mfaDevices(model.mfaDevices);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final List<MFADevice.Builder> getMfaDevices() {
            List<MFADevice.Builder> result = _mfaDeviceListTypeCopier.copyToBuilder(this.mfaDevices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMfaDevices(Collection<MFADevice.BuilderImpl> mfaDevices) {
            this.mfaDevices = _mfaDeviceListTypeCopier.copyFromBuilder(mfaDevices);
        }

        @Override
        public final Builder mfaDevices(Collection<MFADevice> mfaDevices) {
            this.mfaDevices = _mfaDeviceListTypeCopier.copy(mfaDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaDevices(MFADevice ... mfaDevices) {
            this.mfaDevices(Arrays.asList(mfaDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaDevices(Consumer<MFADevice.Builder> ... mfaDevices) {
            this.mfaDevices(Stream.of(mfaDevices).map(c -> (MFADevice)((MFADevice.Builder)MFADevice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListMfaDevicesResponse build() {
            return new ListMfaDevicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMfaDevicesResponse> {
        public Builder mfaDevices(Collection<MFADevice> var1);

        public Builder mfaDevices(MFADevice ... var1);

        public Builder mfaDevices(Consumer<MFADevice.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

