/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.EntityType;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.services.iam.model._entityListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccountAuthorizationDetailsRequest
extends IamRequest
implements ToCopyableBuilder<Builder, GetAccountAuthorizationDetailsRequest> {
    private static final SdkField<List<String>> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filter").getter(GetAccountAuthorizationDetailsRequest.getter(GetAccountAuthorizationDetailsRequest::filterAsStrings)).setter(GetAccountAuthorizationDetailsRequest.setter(Builder::filterWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(GetAccountAuthorizationDetailsRequest.getter(GetAccountAuthorizationDetailsRequest::maxItems)).setter(GetAccountAuthorizationDetailsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(GetAccountAuthorizationDetailsRequest.getter(GetAccountAuthorizationDetailsRequest::marker)).setter(GetAccountAuthorizationDetailsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, MAX_ITEMS_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAccountAuthorizationDetailsRequest.memberNameToFieldInitializer();
    private final List<String> filter;
    private final Integer maxItems;
    private final String marker;

    private GetAccountAuthorizationDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
    }

    public final List<EntityType> filter() {
        return _entityListTypeCopier.copyStringToEnum(this.filter);
    }

    public final boolean hasFilter() {
        return this.filter != null && !(this.filter instanceof SdkAutoConstructList);
    }

    public final List<String> filterAsStrings() {
        return this.filter;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilter() ? this.filterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountAuthorizationDetailsRequest)) {
            return false;
        }
        GetAccountAuthorizationDetailsRequest other = (GetAccountAuthorizationDetailsRequest)((Object)obj);
        return this.hasFilter() == other.hasFilter() && Objects.equals(this.filterAsStrings(), other.filterAsStrings()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccountAuthorizationDetailsRequest").add("Filter", this.hasFilter() ? this.filterAsStrings() : null).add("MaxItems", (Object)this.maxItems()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filterAsStrings()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Filter", FILTER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccountAuthorizationDetailsRequest, T> g) {
        return obj -> g.apply((GetAccountAuthorizationDetailsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private List<String> filter = DefaultSdkAutoConstructList.getInstance();
        private Integer maxItems;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountAuthorizationDetailsRequest model) {
            super(model);
            this.filterWithStrings(model.filter);
            this.maxItems(model.maxItems);
            this.marker(model.marker);
        }

        public final Collection<String> getFilter() {
            if (this.filter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filter;
        }

        public final void setFilter(Collection<String> filter) {
            this.filter = _entityListTypeCopier.copy(filter);
        }

        @Override
        public final Builder filterWithStrings(Collection<String> filter) {
            this.filter = _entityListTypeCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterWithStrings(String ... filter) {
            this.filterWithStrings(Arrays.asList(filter));
            return this;
        }

        @Override
        public final Builder filter(Collection<EntityType> filter) {
            this.filter = _entityListTypeCopier.copyEnumToString(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(EntityType ... filter) {
            this.filter(Arrays.asList(filter));
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAccountAuthorizationDetailsRequest build() {
            return new GetAccountAuthorizationDetailsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccountAuthorizationDetailsRequest> {
        public Builder filterWithStrings(Collection<String> var1);

        public Builder filterWithStrings(String ... var1);

        public Builder filter(Collection<EntityType> var1);

        public Builder filter(EntityType ... var1);

        public Builder maxItems(Integer var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

