/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iam.endpoints.IamEndpointParams;
import software.amazon.awssdk.services.iam.endpoints.IamEndpointProvider;
import software.amazon.awssdk.services.iam.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.iam.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.iam.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultIamEndpointProvider
implements IamEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(IamEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultIamEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(IamEndpointParams params, LocalState locals) {
        RuleResult result = DefaultIamEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultIamEndpointProvider.endpointRule6(params, locals);
    }

    private static RuleResult endpointRule1(IamEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultIamEndpointProvider.endpointRule2(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultIamEndpointProvider.endpointRule3(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(IamEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(IamEndpointParams params, LocalState locals) {
        RuleResult result = DefaultIamEndpointProvider.endpointRule4(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultIamEndpointProvider.endpointRule5(params, locals);
    }

    private static RuleResult endpointRule4(IamEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(IamEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule6(IamEndpointParams params, LocalState locals) {
        RuleResult result = DefaultIamEndpointProvider.endpointRule7(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultIamEndpointProvider.endpointRule37(params, locals);
    }

    private static RuleResult endpointRule7(IamEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultIamEndpointProvider.endpointRule8(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(IamEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultIamEndpointProvider.endpointRule9(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule10(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule11(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule12(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule13(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule14(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule15(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule16(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule17(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule18(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule19(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule20(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule21(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule22(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule23(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule24(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule28(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIamEndpointProvider.endpointRule32(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultIamEndpointProvider.endpointRule36(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(IamEndpointParams params, LocalState locals) {
        if ("aws".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.global.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(IamEndpointParams params, LocalState locals) {
        if ("aws".equals(locals.partitionResult().name()) && params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam-fips.global.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(IamEndpointParams params, LocalState locals) {
        if ("aws-cn".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.global.api.amazonwebservices.com.cn")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("cn-north-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(IamEndpointParams params, LocalState locals) {
        if ("aws-cn".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.cn-north-1.amazonaws.com.cn")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("cn-north-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(IamEndpointParams params, LocalState locals) {
        if ("aws-us-gov".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.us-gov.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-gov-west-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(IamEndpointParams params, LocalState locals) {
        if ("aws-us-gov".equals(locals.partitionResult().name()) && params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.us-gov.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-gov-west-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(IamEndpointParams params, LocalState locals) {
        if ("aws-us-gov".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.us-gov.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-gov-west-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(IamEndpointParams params, LocalState locals) {
        if ("aws-us-gov".equals(locals.partitionResult().name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.us-gov.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-gov-west-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(IamEndpointParams params, LocalState locals) {
        if ("aws-iso".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.us-iso-east-1.c2s.ic.gov")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-iso-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(IamEndpointParams params, LocalState locals) {
        if ("aws-iso".equals(locals.partitionResult().name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam-fips.us-iso-east-1.c2s.ic.gov")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-iso-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule19(IamEndpointParams params, LocalState locals) {
        if ("aws-iso-b".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.us-isob-east-1.sc2s.sgov.gov")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-isob-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(IamEndpointParams params, LocalState locals) {
        if ("aws-iso-b".equals(locals.partitionResult().name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam-fips.us-isob-east-1.sc2s.sgov.gov")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-isob-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(IamEndpointParams params, LocalState locals) {
        if ("aws-iso-e".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.eu-isoe-west-1.cloud.adc-e.uk")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("eu-isoe-west-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule22(IamEndpointParams params, LocalState locals) {
        if ("aws-iso-f".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.us-isof-south-1.csp.hci.ic.gov")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-isof-south-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule23(IamEndpointParams params, LocalState locals) {
        if ("aws-eusc".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam.eusc-de-east-1.amazonaws.eu")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("eusc-de-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule24(IamEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultIamEndpointProvider.endpointRule25(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultIamEndpointProvider.endpointRule27(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule25(IamEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS() && locals.partitionResult().supportsDualStack()) {
            return DefaultIamEndpointProvider.endpointRule26(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule26(IamEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam-fips." + locals.partitionResult().dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(locals.partitionResult().implicitGlobalRegion()).build())).build());
    }

    private static RuleResult endpointRule27(IamEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static RuleResult endpointRule28(IamEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            RuleResult result = DefaultIamEndpointProvider.endpointRule29(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultIamEndpointProvider.endpointRule31(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule29(IamEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            return DefaultIamEndpointProvider.endpointRule30(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule30(IamEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam-fips." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(locals.partitionResult().implicitGlobalRegion()).build())).build());
    }

    private static RuleResult endpointRule31(IamEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule32(IamEndpointParams params, LocalState locals) {
        if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultIamEndpointProvider.endpointRule33(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultIamEndpointProvider.endpointRule35(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule33(IamEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultIamEndpointProvider.endpointRule34(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule34(IamEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam." + locals.partitionResult().dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(locals.partitionResult().implicitGlobalRegion()).build())).build());
    }

    private static RuleResult endpointRule35(IamEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule36(IamEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://iam." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(locals.partitionResult().implicitGlobalRegion()).build())).build());
    }

    private static RuleResult endpointRule37(IamEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

