/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupsRequest
extends IamRequest
implements ToCopyableBuilder<Builder, ListGroupsRequest> {
    private static final SdkField<String> PATH_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PathPrefix").getter(ListGroupsRequest.getter(ListGroupsRequest::pathPrefix)).setter(ListGroupsRequest.setter(Builder::pathPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathPrefix").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListGroupsRequest.getter(ListGroupsRequest::marker)).setter(ListGroupsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(ListGroupsRequest.getter(ListGroupsRequest::maxItems)).setter(ListGroupsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_PREFIX_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PathPrefix", PATH_PREFIX_FIELD);
            this.put("Marker", MARKER_FIELD);
            this.put("MaxItems", MAX_ITEMS_FIELD);
        }
    });
    private final String pathPrefix;
    private final String marker;
    private final Integer maxItems;

    private ListGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.pathPrefix = builder.pathPrefix;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public final String pathPrefix() {
        return this.pathPrefix;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pathPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsRequest)) {
            return false;
        }
        ListGroupsRequest other = (ListGroupsRequest)((Object)obj);
        return Objects.equals(this.pathPrefix(), other.pathPrefix()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListGroupsRequest").add("PathPrefix", (Object)this.pathPrefix()).add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PathPrefix": {
                return Optional.ofNullable(clazz.cast(this.pathPrefix()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupsRequest, T> g) {
        return obj -> g.apply((ListGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String pathPrefix;
        private String marker;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupsRequest model) {
            super(model);
            this.pathPrefix(model.pathPrefix);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final String getPathPrefix() {
            return this.pathPrefix;
        }

        public final void setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        @Override
        public final Builder pathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGroupsRequest build() {
            return new ListGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroupsRequest> {
        public Builder pathPrefix(String var1);

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

