/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse;
import software.amazon.awssdk.services.iam.model.GroupDetail;
import software.amazon.awssdk.services.iam.model.ManagedPolicyDetail;
import software.amazon.awssdk.services.iam.model.RoleDetail;
import software.amazon.awssdk.services.iam.model.UserDetail;

public class GetAccountAuthorizationDetailsPublisher
implements SdkPublisher<GetAccountAuthorizationDetailsResponse> {
    private final IamAsyncClient client;
    private final GetAccountAuthorizationDetailsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetAccountAuthorizationDetailsPublisher(IamAsyncClient client, GetAccountAuthorizationDetailsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetAccountAuthorizationDetailsPublisher(IamAsyncClient client, GetAccountAuthorizationDetailsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetAccountAuthorizationDetailsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetAccountAuthorizationDetailsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UserDetail> userDetailList() {
        Function<GetAccountAuthorizationDetailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.userDetailList() != null) {
                return response.userDetailList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetAccountAuthorizationDetailsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<GroupDetail> groupDetailList() {
        Function<GetAccountAuthorizationDetailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groupDetailList() != null) {
                return response.groupDetailList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetAccountAuthorizationDetailsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<RoleDetail> roleDetailList() {
        Function<GetAccountAuthorizationDetailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.roleDetailList() != null) {
                return response.roleDetailList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetAccountAuthorizationDetailsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<ManagedPolicyDetail> policies() {
        Function<GetAccountAuthorizationDetailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.policies() != null) {
                return response.policies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetAccountAuthorizationDetailsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetAccountAuthorizationDetailsResponseFetcher
    implements AsyncPageFetcher<GetAccountAuthorizationDetailsResponse> {
        private GetAccountAuthorizationDetailsResponseFetcher() {
        }

        public boolean hasNextPage(GetAccountAuthorizationDetailsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<GetAccountAuthorizationDetailsResponse> nextPage(GetAccountAuthorizationDetailsResponse previousPage) {
            if (previousPage == null) {
                return GetAccountAuthorizationDetailsPublisher.this.client.getAccountAuthorizationDetails(GetAccountAuthorizationDetailsPublisher.this.firstRequest);
            }
            return GetAccountAuthorizationDetailsPublisher.this.client.getAccountAuthorizationDetails((GetAccountAuthorizationDetailsRequest)((Object)GetAccountAuthorizationDetailsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

