/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListSshPublicKeysRequest;
import software.amazon.awssdk.services.iam.model.ListSshPublicKeysResponse;
import software.amazon.awssdk.services.iam.model.SSHPublicKeyMetadata;

public class ListSSHPublicKeysPublisher
implements SdkPublisher<ListSshPublicKeysResponse> {
    private final IamAsyncClient client;
    private final ListSshPublicKeysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSSHPublicKeysPublisher(IamAsyncClient client, ListSshPublicKeysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSSHPublicKeysPublisher(IamAsyncClient client, ListSshPublicKeysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSshPublicKeysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSshPublicKeysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SSHPublicKeyMetadata> sshPublicKeys() {
        Function<ListSshPublicKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.sshPublicKeys() != null) {
                return response.sshPublicKeys().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSshPublicKeysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSshPublicKeysResponseFetcher
    implements AsyncPageFetcher<ListSshPublicKeysResponse> {
        private ListSshPublicKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListSshPublicKeysResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListSshPublicKeysResponse> nextPage(ListSshPublicKeysResponse previousPage) {
            if (previousPage == null) {
                return ListSSHPublicKeysPublisher.this.client.listSSHPublicKeys(ListSSHPublicKeysPublisher.this.firstRequest);
            }
            return ListSSHPublicKeysPublisher.this.client.listSSHPublicKeys((ListSshPublicKeysRequest)((Object)ListSSHPublicKeysPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

