/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListRolesRequest;
import software.amazon.awssdk.services.iam.model.ListRolesResponse;
import software.amazon.awssdk.services.iam.model.Role;

public class ListRolesPublisher
implements SdkPublisher<ListRolesResponse> {
    private final IamAsyncClient client;
    private final ListRolesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRolesPublisher(IamAsyncClient client, ListRolesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRolesPublisher(IamAsyncClient client, ListRolesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRolesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRolesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Role> roles() {
        Function<ListRolesResponse, Iterator> getIterator = response -> {
            if (response != null && response.roles() != null) {
                return response.roles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRolesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRolesResponseFetcher
    implements AsyncPageFetcher<ListRolesResponse> {
        private ListRolesResponseFetcher() {
        }

        public boolean hasNextPage(ListRolesResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListRolesResponse> nextPage(ListRolesResponse previousPage) {
            if (previousPage == null) {
                return ListRolesPublisher.this.client.listRoles(ListRolesPublisher.this.firstRequest);
            }
            return ListRolesPublisher.this.client.listRoles((ListRolesRequest)((Object)ListRolesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

