/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.beans.Transient;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.Tag;
import software.amazon.awssdk.services.iam.model.User;
import software.amazon.awssdk.services.iam.model._tagListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualMFADevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualMFADevice> {
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SerialNumber").getter(VirtualMFADevice.getter(VirtualMFADevice::serialNumber)).setter(VirtualMFADevice.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()}).build();
    private static final SdkField<SdkBytes> BASE32_STRING_SEED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Base32StringSeed").getter(VirtualMFADevice.getter(VirtualMFADevice::base32StringSeed)).setter(VirtualMFADevice.setter(Builder::base32StringSeed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Base32StringSeed").build()}).build();
    private static final SdkField<SdkBytes> QR_CODE_PNG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("QRCodePNG").getter(VirtualMFADevice.getter(VirtualMFADevice::qrCodePNG)).setter(VirtualMFADevice.setter(Builder::qrCodePNG)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QRCodePNG").build()}).build();
    private static final SdkField<User> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("User").getter(VirtualMFADevice.getter(VirtualMFADevice::user)).setter(VirtualMFADevice.setter(Builder::user)).constructor(User::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()}).build();
    private static final SdkField<Instant> ENABLE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EnableDate").getter(VirtualMFADevice.getter(VirtualMFADevice::enableDate)).setter(VirtualMFADevice.setter(Builder::enableDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDate").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(VirtualMFADevice.getter(VirtualMFADevice::tags)).setter(VirtualMFADevice.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERIAL_NUMBER_FIELD, BASE32_STRING_SEED_FIELD, QR_CODE_PNG_FIELD, USER_FIELD, ENABLE_DATE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serialNumber;
    private final SdkBytes base32StringSeed;
    private final SdkBytes qrCodePNG;
    private final User user;
    private final Instant enableDate;
    private final List<Tag> tags;

    private VirtualMFADevice(BuilderImpl builder) {
        this.serialNumber = builder.serialNumber;
        this.base32StringSeed = builder.base32StringSeed;
        this.qrCodePNG = builder.qrCodePNG;
        this.user = builder.user;
        this.enableDate = builder.enableDate;
        this.tags = builder.tags;
    }

    public final String serialNumber() {
        return this.serialNumber;
    }

    public final SdkBytes base32StringSeed() {
        return this.base32StringSeed;
    }

    public final SdkBytes qrCodePNG() {
        return this.qrCodePNG;
    }

    public final User user() {
        return this.user;
    }

    public final Instant enableDate() {
        return this.enableDate;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.base32StringSeed());
        hashCode = 31 * hashCode + Objects.hashCode(this.qrCodePNG());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualMFADevice)) {
            return false;
        }
        VirtualMFADevice other = (VirtualMFADevice)obj;
        return Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.base32StringSeed(), other.base32StringSeed()) && Objects.equals(this.qrCodePNG(), other.qrCodePNG()) && Objects.equals(this.user(), other.user()) && Objects.equals(this.enableDate(), other.enableDate()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"VirtualMFADevice").add("SerialNumber", (Object)this.serialNumber()).add("Base32StringSeed", (Object)(this.base32StringSeed() == null ? null : "*** Sensitive Data Redacted ***")).add("QRCodePNG", (Object)(this.qrCodePNG() == null ? null : "*** Sensitive Data Redacted ***")).add("User", (Object)this.user()).add("EnableDate", (Object)this.enableDate()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "Base32StringSeed": {
                return Optional.ofNullable(clazz.cast(this.base32StringSeed()));
            }
            case "QRCodePNG": {
                return Optional.ofNullable(clazz.cast(this.qrCodePNG()));
            }
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "EnableDate": {
                return Optional.ofNullable(clazz.cast(this.enableDate()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualMFADevice, T> g) {
        return obj -> g.apply((VirtualMFADevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serialNumber;
        private SdkBytes base32StringSeed;
        private SdkBytes qrCodePNG;
        private User user;
        private Instant enableDate;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualMFADevice model) {
            this.serialNumber(model.serialNumber);
            this.base32StringSeed(model.base32StringSeed);
            this.qrCodePNG(model.qrCodePNG);
            this.user(model.user);
            this.enableDate(model.enableDate);
            this.tags(model.tags);
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        @Transient
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final ByteBuffer getBase32StringSeed() {
            return this.base32StringSeed == null ? null : this.base32StringSeed.asByteBuffer();
        }

        public final void setBase32StringSeed(ByteBuffer base32StringSeed) {
            this.base32StringSeed(base32StringSeed == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)base32StringSeed));
        }

        @Override
        @Transient
        public final Builder base32StringSeed(SdkBytes base32StringSeed) {
            this.base32StringSeed = base32StringSeed;
            return this;
        }

        public final ByteBuffer getQrCodePNG() {
            return this.qrCodePNG == null ? null : this.qrCodePNG.asByteBuffer();
        }

        public final void setQrCodePNG(ByteBuffer qrCodePNG) {
            this.qrCodePNG(qrCodePNG == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)qrCodePNG));
        }

        @Override
        @Transient
        public final Builder qrCodePNG(SdkBytes qrCodePNG) {
            this.qrCodePNG = qrCodePNG;
            return this;
        }

        public final User.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        public final void setUser(User.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        @Transient
        public final Builder user(User user) {
            this.user = user;
            return this;
        }

        public final Instant getEnableDate() {
            return this.enableDate;
        }

        public final void setEnableDate(Instant enableDate) {
            this.enableDate = enableDate;
        }

        @Override
        @Transient
        public final Builder enableDate(Instant enableDate) {
            this.enableDate = enableDate;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = _tagListTypeCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListTypeCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public VirtualMFADevice build() {
            return new VirtualMFADevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualMFADevice> {
        public Builder serialNumber(String var1);

        public Builder base32StringSeed(SdkBytes var1);

        public Builder qrCodePNG(SdkBytes var1);

        public Builder user(User var1);

        default public Builder user(Consumer<User.Builder> user) {
            return this.user((User)((User.Builder)User.builder().applyMutation(user)).build());
        }

        public Builder enableDate(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

