/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessDetail> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(AccessDetail.getter(AccessDetail::serviceName)).setter(AccessDetail.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceNamespace").getter(AccessDetail.getter(AccessDetail::serviceNamespace)).setter(AccessDetail.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(AccessDetail.getter(AccessDetail::region)).setter(AccessDetail.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> ENTITY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityPath").getter(AccessDetail.getter(AccessDetail::entityPath)).setter(AccessDetail.setter(Builder::entityPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityPath").build()}).build();
    private static final SdkField<Instant> LAST_AUTHENTICATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastAuthenticatedTime").getter(AccessDetail.getter(AccessDetail::lastAuthenticatedTime)).setter(AccessDetail.setter(Builder::lastAuthenticatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAuthenticatedTime").build()}).build();
    private static final SdkField<Integer> TOTAL_AUTHENTICATED_ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalAuthenticatedEntities").getter(AccessDetail.getter(AccessDetail::totalAuthenticatedEntities)).setter(AccessDetail.setter(Builder::totalAuthenticatedEntities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAuthenticatedEntities").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD, SERVICE_NAMESPACE_FIELD, REGION_FIELD, ENTITY_PATH_FIELD, LAST_AUTHENTICATED_TIME_FIELD, TOTAL_AUTHENTICATED_ENTITIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceName;
    private final String serviceNamespace;
    private final String region;
    private final String entityPath;
    private final Instant lastAuthenticatedTime;
    private final Integer totalAuthenticatedEntities;

    private AccessDetail(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.serviceNamespace = builder.serviceNamespace;
        this.region = builder.region;
        this.entityPath = builder.entityPath;
        this.lastAuthenticatedTime = builder.lastAuthenticatedTime;
        this.totalAuthenticatedEntities = builder.totalAuthenticatedEntities;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String serviceNamespace() {
        return this.serviceNamespace;
    }

    public final String region() {
        return this.region;
    }

    public final String entityPath() {
        return this.entityPath;
    }

    public final Instant lastAuthenticatedTime() {
        return this.lastAuthenticatedTime;
    }

    public final Integer totalAuthenticatedEntities() {
        return this.totalAuthenticatedEntities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAuthenticatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAuthenticatedEntities());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessDetail)) {
            return false;
        }
        AccessDetail other = (AccessDetail)obj;
        return Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceNamespace(), other.serviceNamespace()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.entityPath(), other.entityPath()) && Objects.equals(this.lastAuthenticatedTime(), other.lastAuthenticatedTime()) && Objects.equals(this.totalAuthenticatedEntities(), other.totalAuthenticatedEntities());
    }

    public final String toString() {
        return ToString.builder((String)"AccessDetail").add("ServiceName", (Object)this.serviceName()).add("ServiceNamespace", (Object)this.serviceNamespace()).add("Region", (Object)this.region()).add("EntityPath", (Object)this.entityPath()).add("LastAuthenticatedTime", (Object)this.lastAuthenticatedTime()).add("TotalAuthenticatedEntities", (Object)this.totalAuthenticatedEntities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "ServiceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespace()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "EntityPath": {
                return Optional.ofNullable(clazz.cast(this.entityPath()));
            }
            case "LastAuthenticatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastAuthenticatedTime()));
            }
            case "TotalAuthenticatedEntities": {
                return Optional.ofNullable(clazz.cast(this.totalAuthenticatedEntities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessDetail, T> g) {
        return obj -> g.apply((AccessDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceName;
        private String serviceNamespace;
        private String region;
        private String entityPath;
        private Instant lastAuthenticatedTime;
        private Integer totalAuthenticatedEntities;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessDetail model) {
            this.serviceName(model.serviceName);
            this.serviceNamespace(model.serviceNamespace);
            this.region(model.region);
            this.entityPath(model.entityPath);
            this.lastAuthenticatedTime(model.lastAuthenticatedTime);
            this.totalAuthenticatedEntities(model.totalAuthenticatedEntities);
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getEntityPath() {
            return this.entityPath;
        }

        public final void setEntityPath(String entityPath) {
            this.entityPath = entityPath;
        }

        @Override
        public final Builder entityPath(String entityPath) {
            this.entityPath = entityPath;
            return this;
        }

        public final Instant getLastAuthenticatedTime() {
            return this.lastAuthenticatedTime;
        }

        public final void setLastAuthenticatedTime(Instant lastAuthenticatedTime) {
            this.lastAuthenticatedTime = lastAuthenticatedTime;
        }

        @Override
        public final Builder lastAuthenticatedTime(Instant lastAuthenticatedTime) {
            this.lastAuthenticatedTime = lastAuthenticatedTime;
            return this;
        }

        public final Integer getTotalAuthenticatedEntities() {
            return this.totalAuthenticatedEntities;
        }

        public final void setTotalAuthenticatedEntities(Integer totalAuthenticatedEntities) {
            this.totalAuthenticatedEntities = totalAuthenticatedEntities;
        }

        @Override
        public final Builder totalAuthenticatedEntities(Integer totalAuthenticatedEntities) {
            this.totalAuthenticatedEntities = totalAuthenticatedEntities;
            return this;
        }

        public AccessDetail build() {
            return new AccessDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessDetail> {
        public Builder serviceName(String var1);

        public Builder serviceNamespace(String var1);

        public Builder region(String var1);

        public Builder entityPath(String var1);

        public Builder lastAuthenticatedTime(Instant var1);

        public Builder totalAuthenticatedEntities(Integer var1);
    }
}

