/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.services.iam.model._thumbprintListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOpenIdConnectProviderThumbprintRequest
extends IamRequest
implements ToCopyableBuilder<Builder, UpdateOpenIdConnectProviderThumbprintRequest> {
    private static final SdkField<String> OPEN_ID_CONNECT_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpenIDConnectProviderArn").getter(UpdateOpenIdConnectProviderThumbprintRequest.getter(UpdateOpenIdConnectProviderThumbprintRequest::openIDConnectProviderArn)).setter(UpdateOpenIdConnectProviderThumbprintRequest.setter(Builder::openIDConnectProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenIDConnectProviderArn").build()}).build();
    private static final SdkField<List<String>> THUMBPRINT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ThumbprintList").getter(UpdateOpenIdConnectProviderThumbprintRequest.getter(UpdateOpenIdConnectProviderThumbprintRequest::thumbprintList)).setter(UpdateOpenIdConnectProviderThumbprintRequest.setter(Builder::thumbprintList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbprintList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_ID_CONNECT_PROVIDER_ARN_FIELD, THUMBPRINT_LIST_FIELD));
    private final String openIDConnectProviderArn;
    private final List<String> thumbprintList;

    private UpdateOpenIdConnectProviderThumbprintRequest(BuilderImpl builder) {
        super(builder);
        this.openIDConnectProviderArn = builder.openIDConnectProviderArn;
        this.thumbprintList = builder.thumbprintList;
    }

    public final String openIDConnectProviderArn() {
        return this.openIDConnectProviderArn;
    }

    public final boolean hasThumbprintList() {
        return this.thumbprintList != null && !(this.thumbprintList instanceof SdkAutoConstructList);
    }

    public final List<String> thumbprintList() {
        return this.thumbprintList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.openIDConnectProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThumbprintList() ? this.thumbprintList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOpenIdConnectProviderThumbprintRequest)) {
            return false;
        }
        UpdateOpenIdConnectProviderThumbprintRequest other = (UpdateOpenIdConnectProviderThumbprintRequest)((Object)obj);
        return Objects.equals(this.openIDConnectProviderArn(), other.openIDConnectProviderArn()) && this.hasThumbprintList() == other.hasThumbprintList() && Objects.equals(this.thumbprintList(), other.thumbprintList());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOpenIdConnectProviderThumbprintRequest").add("OpenIDConnectProviderArn", (Object)this.openIDConnectProviderArn()).add("ThumbprintList", this.hasThumbprintList() ? this.thumbprintList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpenIDConnectProviderArn": {
                return Optional.ofNullable(clazz.cast(this.openIDConnectProviderArn()));
            }
            case "ThumbprintList": {
                return Optional.ofNullable(clazz.cast(this.thumbprintList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOpenIdConnectProviderThumbprintRequest, T> g) {
        return obj -> g.apply((UpdateOpenIdConnectProviderThumbprintRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String openIDConnectProviderArn;
        private List<String> thumbprintList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOpenIdConnectProviderThumbprintRequest model) {
            super(model);
            this.openIDConnectProviderArn(model.openIDConnectProviderArn);
            this.thumbprintList(model.thumbprintList);
        }

        public final String getOpenIDConnectProviderArn() {
            return this.openIDConnectProviderArn;
        }

        public final void setOpenIDConnectProviderArn(String openIDConnectProviderArn) {
            this.openIDConnectProviderArn = openIDConnectProviderArn;
        }

        @Override
        @Transient
        public final Builder openIDConnectProviderArn(String openIDConnectProviderArn) {
            this.openIDConnectProviderArn = openIDConnectProviderArn;
            return this;
        }

        public final Collection<String> getThumbprintList() {
            if (this.thumbprintList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.thumbprintList;
        }

        public final void setThumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
        }

        @Override
        @Transient
        public final Builder thumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder thumbprintList(String ... thumbprintList) {
            this.thumbprintList(Arrays.asList(thumbprintList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOpenIdConnectProviderThumbprintRequest build() {
            return new UpdateOpenIdConnectProviderThumbprintRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateOpenIdConnectProviderThumbprintRequest> {
        public Builder openIDConnectProviderArn(String var1);

        public Builder thumbprintList(Collection<String> var1);

        public Builder thumbprintList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

