/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRolePolicyResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetRolePolicyResponse> {
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleName").getter(GetRolePolicyResponse.getter(GetRolePolicyResponse::roleName)).setter(GetRolePolicyResponse.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(GetRolePolicyResponse.getter(GetRolePolicyResponse::policyName)).setter(GetRolePolicyResponse.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyDocument").getter(GetRolePolicyResponse.getter(GetRolePolicyResponse::policyDocument)).setter(GetRolePolicyResponse.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_NAME_FIELD, POLICY_NAME_FIELD, POLICY_DOCUMENT_FIELD));
    private final String roleName;
    private final String policyName;
    private final String policyDocument;

    private GetRolePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.roleName = builder.roleName;
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
    }

    public final String roleName() {
        return this.roleName;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRolePolicyResponse)) {
            return false;
        }
        GetRolePolicyResponse other = (GetRolePolicyResponse)((Object)obj);
        return Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyDocument(), other.policyDocument());
    }

    public final String toString() {
        return ToString.builder((String)"GetRolePolicyResponse").add("RoleName", (Object)this.roleName()).add("PolicyName", (Object)this.policyName()).add("PolicyDocument", (Object)this.policyDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "PolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRolePolicyResponse, T> g) {
        return obj -> g.apply((GetRolePolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private String roleName;
        private String policyName;
        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRolePolicyResponse model) {
            super(model);
            this.roleName(model.roleName);
            this.policyName(model.policyName);
            this.policyDocument(model.policyDocument);
        }

        public final String getRoleName() {
            return this.roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        @Transient
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        @Transient
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        @Transient
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        @Override
        public GetRolePolicyResponse build() {
            return new GetRolePolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRolePolicyResponse> {
        public Builder roleName(String var1);

        public Builder policyName(String var1);

        public Builder policyDocument(String var1);
    }
}

