/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an IAM role. This structure is returned as a response element in several API operations
 * that interact with roles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Role implements SdkPojo, Serializable, ToCopyableBuilder<Role.Builder, Role> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(Role::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleName").getter(getter(Role::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()).build();

    private static final SdkField<String> ROLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RoleId")
            .getter(getter(Role::roleId)).setter(setter(Builder::roleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Role::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(Role::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> ASSUME_ROLE_POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssumeRolePolicyDocument").getter(getter(Role::assumeRolePolicyDocument))
            .setter(setter(Builder::assumeRolePolicyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssumeRolePolicyDocument").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Role::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> MAX_SESSION_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSessionDuration").getter(getter(Role::maxSessionDuration))
            .setter(setter(Builder::maxSessionDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSessionDuration").build())
            .build();

    private static final SdkField<AttachedPermissionsBoundary> PERMISSIONS_BOUNDARY_FIELD = SdkField
            .<AttachedPermissionsBoundary> builder(MarshallingType.SDK_POJO).memberName("PermissionsBoundary")
            .getter(getter(Role::permissionsBoundary)).setter(setter(Builder::permissionsBoundary))
            .constructor(AttachedPermissionsBoundary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundary").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Role::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RoleLastUsed> ROLE_LAST_USED_FIELD = SdkField.<RoleLastUsed> builder(MarshallingType.SDK_POJO)
            .memberName("RoleLastUsed").getter(getter(Role::roleLastUsed)).setter(setter(Builder::roleLastUsed))
            .constructor(RoleLastUsed::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleLastUsed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, ROLE_NAME_FIELD,
            ROLE_ID_FIELD, ARN_FIELD, CREATE_DATE_FIELD, ASSUME_ROLE_POLICY_DOCUMENT_FIELD, DESCRIPTION_FIELD,
            MAX_SESSION_DURATION_FIELD, PERMISSIONS_BOUNDARY_FIELD, TAGS_FIELD, ROLE_LAST_USED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String path;

    private final String roleName;

    private final String roleId;

    private final String arn;

    private final Instant createDate;

    private final String assumeRolePolicyDocument;

    private final String description;

    private final Integer maxSessionDuration;

    private final AttachedPermissionsBoundary permissionsBoundary;

    private final List<Tag> tags;

    private final RoleLastUsed roleLastUsed;

    private Role(BuilderImpl builder) {
        this.path = builder.path;
        this.roleName = builder.roleName;
        this.roleId = builder.roleId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.assumeRolePolicyDocument = builder.assumeRolePolicyDocument;
        this.description = builder.description;
        this.maxSessionDuration = builder.maxSessionDuration;
        this.permissionsBoundary = builder.permissionsBoundary;
        this.tags = builder.tags;
        this.roleLastUsed = builder.roleLastUsed;
    }

    /**
     * <p>
     * The path to the role. For more information about paths, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     * 
     * @return The path to the role. For more information about paths, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
     *         <i>IAM User Guide</i>.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The friendly name that identifies the role.
     * </p>
     * 
     * @return The friendly name that identifies the role.
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * <p>
     * The stable and unique string identifying the role. For more information about IDs, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     * 
     * @return The stable and unique string identifying the role. For more information about IDs, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
     *         <i>IAM User Guide</i>.
     */
    public final String roleId() {
        return roleId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) specifying the role. For more information about ARNs and how to use them in
     * policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     * identifiers</a> in the <i>IAM User Guide</i> guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) specifying the role. For more information about ARNs and how to use them
     *         in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
     *         identifiers</a> in the <i>IAM User Guide</i> guide.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the role was
     * created.
     * </p>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     *         role was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The policy that grants an entity permission to assume the role.
     * </p>
     * 
     * @return The policy that grants an entity permission to assume the role.
     */
    public final String assumeRolePolicyDocument() {
        return assumeRolePolicyDocument;
    }

    /**
     * <p>
     * A description of the role that you provide.
     * </p>
     * 
     * @return A description of the role that you provide.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The maximum session duration (in seconds) for the specified role. Anyone who uses the AWS CLI, or API to assume
     * the role can specify the duration using the optional <code>DurationSeconds</code> API parameter or
     * <code>duration-seconds</code> CLI parameter.
     * </p>
     * 
     * @return The maximum session duration (in seconds) for the specified role. Anyone who uses the AWS CLI, or API to
     *         assume the role can specify the duration using the optional <code>DurationSeconds</code> API parameter or
     *         <code>duration-seconds</code> CLI parameter.
     */
    public final Integer maxSessionDuration() {
        return maxSessionDuration;
    }

    /**
     * <p>
     * The ARN of the policy used to set the permissions boundary for the role.
     * </p>
     * <p>
     * For more information about permissions boundaries, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries
     * for IAM identities </a> in the <i>IAM User Guide</i>.
     * </p>
     * 
     * @return The ARN of the policy used to set the permissions boundary for the role.</p>
     *         <p>
     *         For more information about permissions boundaries, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
     *         boundaries for IAM identities </a> in the <i>IAM User Guide</i>.
     */
    public final AttachedPermissionsBoundary permissionsBoundary() {
        return permissionsBoundary;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags that are attached to the role. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags that are attached to the role. For more information about tagging, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
     *         <i>IAM User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Contains information about the last time that an IAM role was used. This includes the date and time and the
     * Region in which the role was last used. Activity is only reported for the trailing 400 days. This period can be
     * shorter if your Region began supporting these features within the last year. The role might have been used more
     * than 400 days ago. For more information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period"
     * >Regions where data is tracked</a> in the <i>IAM User Guide</i>.
     * </p>
     * 
     * @return Contains information about the last time that an IAM role was used. This includes the date and time and
     *         the Region in which the role was last used. Activity is only reported for the trailing 400 days. This
     *         period can be shorter if your Region began supporting these features within the last year. The role might
     *         have been used more than 400 days ago. For more information, see <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period"
     *         >Regions where data is tracked</a> in the <i>IAM User Guide</i>.
     */
    public final RoleLastUsed roleLastUsed() {
        return roleLastUsed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(roleId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(assumeRolePolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(maxSessionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleLastUsed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Role)) {
            return false;
        }
        Role other = (Role) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(roleName(), other.roleName())
                && Objects.equals(roleId(), other.roleId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createDate(), other.createDate())
                && Objects.equals(assumeRolePolicyDocument(), other.assumeRolePolicyDocument())
                && Objects.equals(description(), other.description())
                && Objects.equals(maxSessionDuration(), other.maxSessionDuration())
                && Objects.equals(permissionsBoundary(), other.permissionsBoundary()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(roleLastUsed(), other.roleLastUsed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Role").add("Path", path()).add("RoleName", roleName()).add("RoleId", roleId()).add("Arn", arn())
                .add("CreateDate", createDate()).add("AssumeRolePolicyDocument", assumeRolePolicyDocument())
                .add("Description", description()).add("MaxSessionDuration", maxSessionDuration())
                .add("PermissionsBoundary", permissionsBoundary()).add("Tags", hasTags() ? tags() : null)
                .add("RoleLastUsed", roleLastUsed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "RoleId":
            return Optional.ofNullable(clazz.cast(roleId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "AssumeRolePolicyDocument":
            return Optional.ofNullable(clazz.cast(assumeRolePolicyDocument()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "MaxSessionDuration":
            return Optional.ofNullable(clazz.cast(maxSessionDuration()));
        case "PermissionsBoundary":
            return Optional.ofNullable(clazz.cast(permissionsBoundary()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "RoleLastUsed":
            return Optional.ofNullable(clazz.cast(roleLastUsed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Role, T> g) {
        return obj -> g.apply((Role) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Role> {
        /**
         * <p>
         * The path to the role. For more information about paths, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * 
         * @param path
         *        The path to the role. For more information about paths, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in
         *        the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The friendly name that identifies the role.
         * </p>
         * 
         * @param roleName
         *        The friendly name that identifies the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The stable and unique string identifying the role. For more information about IDs, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * 
         * @param roleId
         *        The stable and unique string identifying the role. For more information about IDs, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in
         *        the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleId(String roleId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) specifying the role. For more information about ARNs and how to use them in
         * policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
         * identifiers</a> in the <i>IAM User Guide</i> guide.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) specifying the role. For more information about ARNs and how to use
         *        them in policies, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in
         *        the <i>IAM User Guide</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the role
         * was created.
         * </p>
         * 
         * @param createDate
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         *        role was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The policy that grants an entity permission to assume the role.
         * </p>
         * 
         * @param assumeRolePolicyDocument
         *        The policy that grants an entity permission to assume the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumeRolePolicyDocument(String assumeRolePolicyDocument);

        /**
         * <p>
         * A description of the role that you provide.
         * </p>
         * 
         * @param description
         *        A description of the role that you provide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The maximum session duration (in seconds) for the specified role. Anyone who uses the AWS CLI, or API to
         * assume the role can specify the duration using the optional <code>DurationSeconds</code> API parameter or
         * <code>duration-seconds</code> CLI parameter.
         * </p>
         * 
         * @param maxSessionDuration
         *        The maximum session duration (in seconds) for the specified role. Anyone who uses the AWS CLI, or API
         *        to assume the role can specify the duration using the optional <code>DurationSeconds</code> API
         *        parameter or <code>duration-seconds</code> CLI parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSessionDuration(Integer maxSessionDuration);

        /**
         * <p>
         * The ARN of the policy used to set the permissions boundary for the role.
         * </p>
         * <p>
         * For more information about permissions boundaries, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         * boundaries for IAM identities </a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param permissionsBoundary
         *        The ARN of the policy used to set the permissions boundary for the role.</p>
         *        <p>
         *        For more information about permissions boundaries, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         *        boundaries for IAM identities </a> in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsBoundary(AttachedPermissionsBoundary permissionsBoundary);

        /**
         * <p>
         * The ARN of the policy used to set the permissions boundary for the role.
         * </p>
         * <p>
         * For more information about permissions boundaries, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         * boundaries for IAM identities </a> in the <i>IAM User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link AttachedPermissionsBoundary.Builder} avoiding
         * the need to create one manually via {@link AttachedPermissionsBoundary#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttachedPermissionsBoundary.Builder#build()} is called
         * immediately and its result is passed to {@link #permissionsBoundary(AttachedPermissionsBoundary)}.
         * 
         * @param permissionsBoundary
         *        a consumer that will call methods on {@link AttachedPermissionsBoundary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionsBoundary(AttachedPermissionsBoundary)
         */
        default Builder permissionsBoundary(Consumer<AttachedPermissionsBoundary.Builder> permissionsBoundary) {
            return permissionsBoundary(AttachedPermissionsBoundary.builder().applyMutation(permissionsBoundary).build());
        }

        /**
         * <p>
         * A list of tags that are attached to the role. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags that are attached to the role. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
         *        <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags that are attached to the role. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags that are attached to the role. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
         *        <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags that are attached to the role. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Contains information about the last time that an IAM role was used. This includes the date and time and the
         * Region in which the role was last used. Activity is only reported for the trailing 400 days. This period can
         * be shorter if your Region began supporting these features within the last year. The role might have been used
         * more than 400 days ago. For more information, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period"
         * >Regions where data is tracked</a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param roleLastUsed
         *        Contains information about the last time that an IAM role was used. This includes the date and time
         *        and the Region in which the role was last used. Activity is only reported for the trailing 400 days.
         *        This period can be shorter if your Region began supporting these features within the last year. The
         *        role might have been used more than 400 days ago. For more information, see <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period"
         *        >Regions where data is tracked</a> in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleLastUsed(RoleLastUsed roleLastUsed);

        /**
         * <p>
         * Contains information about the last time that an IAM role was used. This includes the date and time and the
         * Region in which the role was last used. Activity is only reported for the trailing 400 days. This period can
         * be shorter if your Region began supporting these features within the last year. The role might have been used
         * more than 400 days ago. For more information, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period"
         * >Regions where data is tracked</a> in the <i>IAM User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link RoleLastUsed.Builder} avoiding the need to
         * create one manually via {@link RoleLastUsed#builder()}.
         *
         * When the {@link Consumer} completes, {@link RoleLastUsed.Builder#build()} is called immediately and its
         * result is passed to {@link #roleLastUsed(RoleLastUsed)}.
         * 
         * @param roleLastUsed
         *        a consumer that will call methods on {@link RoleLastUsed.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roleLastUsed(RoleLastUsed)
         */
        default Builder roleLastUsed(Consumer<RoleLastUsed.Builder> roleLastUsed) {
            return roleLastUsed(RoleLastUsed.builder().applyMutation(roleLastUsed).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String path;

        private String roleName;

        private String roleId;

        private String arn;

        private Instant createDate;

        private String assumeRolePolicyDocument;

        private String description;

        private Integer maxSessionDuration;

        private AttachedPermissionsBoundary permissionsBoundary;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private RoleLastUsed roleLastUsed;

        private BuilderImpl() {
        }

        private BuilderImpl(Role model) {
            path(model.path);
            roleName(model.roleName);
            roleId(model.roleId);
            arn(model.arn);
            createDate(model.createDate);
            assumeRolePolicyDocument(model.assumeRolePolicyDocument);
            description(model.description);
            maxSessionDuration(model.maxSessionDuration);
            permissionsBoundary(model.permissionsBoundary);
            tags(model.tags);
            roleLastUsed(model.roleLastUsed);
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getRoleName() {
            return roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getRoleId() {
            return roleId;
        }

        @Override
        public final Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public final void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getAssumeRolePolicyDocument() {
            return assumeRolePolicyDocument;
        }

        @Override
        public final Builder assumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
            return this;
        }

        public final void setAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getMaxSessionDuration() {
            return maxSessionDuration;
        }

        @Override
        public final Builder maxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
            return this;
        }

        public final void setMaxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
        }

        public final AttachedPermissionsBoundary.Builder getPermissionsBoundary() {
            return permissionsBoundary != null ? permissionsBoundary.toBuilder() : null;
        }

        @Override
        public final Builder permissionsBoundary(AttachedPermissionsBoundary permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        public final void setPermissionsBoundary(AttachedPermissionsBoundary.BuilderImpl permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary != null ? permissionsBoundary.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListTypeCopier.copyFromBuilder(tags);
        }

        public final RoleLastUsed.Builder getRoleLastUsed() {
            return roleLastUsed != null ? roleLastUsed.toBuilder() : null;
        }

        @Override
        public final Builder roleLastUsed(RoleLastUsed roleLastUsed) {
            this.roleLastUsed = roleLastUsed;
            return this;
        }

        public final void setRoleLastUsed(RoleLastUsed.BuilderImpl roleLastUsed) {
            this.roleLastUsed = roleLastUsed != null ? roleLastUsed.build() : null;
        }

        @Override
        public Role build() {
            return new Role(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
