/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.RoleUsageListTypeCopier;
import software.amazon.awssdk.services.iam.model.RoleUsageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeletionTaskFailureReasonType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeletionTaskFailureReasonType> {
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(DeletionTaskFailureReasonType.getter(DeletionTaskFailureReasonType::reason)).setter(DeletionTaskFailureReasonType.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final SdkField<List<RoleUsageType>> ROLE_USAGE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoleUsageList").getter(DeletionTaskFailureReasonType.getter(DeletionTaskFailureReasonType::roleUsageList)).setter(DeletionTaskFailureReasonType.setter(Builder::roleUsageList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleUsageList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoleUsageType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD, ROLE_USAGE_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reason;
    private final List<RoleUsageType> roleUsageList;

    private DeletionTaskFailureReasonType(BuilderImpl builder) {
        this.reason = builder.reason;
        this.roleUsageList = builder.roleUsageList;
    }

    public final String reason() {
        return this.reason;
    }

    public final boolean hasRoleUsageList() {
        return this.roleUsageList != null && !(this.roleUsageList instanceof SdkAutoConstructList);
    }

    public final List<RoleUsageType> roleUsageList() {
        return this.roleUsageList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoleUsageList() ? this.roleUsageList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletionTaskFailureReasonType)) {
            return false;
        }
        DeletionTaskFailureReasonType other = (DeletionTaskFailureReasonType)obj;
        return Objects.equals(this.reason(), other.reason()) && this.hasRoleUsageList() == other.hasRoleUsageList() && Objects.equals(this.roleUsageList(), other.roleUsageList());
    }

    public final String toString() {
        return ToString.builder((String)"DeletionTaskFailureReasonType").add("Reason", (Object)this.reason()).add("RoleUsageList", this.hasRoleUsageList() ? this.roleUsageList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "RoleUsageList": {
                return Optional.ofNullable(clazz.cast(this.roleUsageList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletionTaskFailureReasonType, T> g) {
        return obj -> g.apply((DeletionTaskFailureReasonType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reason;
        private List<RoleUsageType> roleUsageList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeletionTaskFailureReasonType model) {
            this.reason(model.reason);
            this.roleUsageList(model.roleUsageList);
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final Collection<RoleUsageType.Builder> getRoleUsageList() {
            if (this.roleUsageList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.roleUsageList != null ? (Collection)this.roleUsageList.stream().map(RoleUsageType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder roleUsageList(Collection<RoleUsageType> roleUsageList) {
            this.roleUsageList = RoleUsageListTypeCopier.copy(roleUsageList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleUsageList(RoleUsageType ... roleUsageList) {
            this.roleUsageList(Arrays.asList(roleUsageList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleUsageList(Consumer<RoleUsageType.Builder> ... roleUsageList) {
            this.roleUsageList(Stream.of(roleUsageList).map(c -> (RoleUsageType)((RoleUsageType.Builder)RoleUsageType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoleUsageList(Collection<RoleUsageType.BuilderImpl> roleUsageList) {
            this.roleUsageList = RoleUsageListTypeCopier.copyFromBuilder(roleUsageList);
        }

        public DeletionTaskFailureReasonType build() {
            return new DeletionTaskFailureReasonType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeletionTaskFailureReasonType> {
        public Builder reason(String var1);

        public Builder roleUsageList(Collection<RoleUsageType> var1);

        public Builder roleUsageList(RoleUsageType ... var1);

        public Builder roleUsageList(Consumer<RoleUsageType.Builder> ... var1);
    }
}

