/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.Group;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.User;
import software.amazon.awssdk.services.iam.model._userListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGroupResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetGroupResponse> {
    private static final SdkField<Group> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Group").getter(GetGroupResponse.getter(GetGroupResponse::group)).setter(GetGroupResponse.setter(Builder::group)).constructor(Group::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()}).build();
    private static final SdkField<List<User>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Users").getter(GetGroupResponse.getter(GetGroupResponse::users)).setter(GetGroupResponse.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(User::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(GetGroupResponse.getter(GetGroupResponse::isTruncated)).setter(GetGroupResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(GetGroupResponse.getter(GetGroupResponse::marker)).setter(GetGroupResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, USERS_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));
    private final Group group;
    private final List<User> users;
    private final Boolean isTruncated;
    private final String marker;

    private GetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.group = builder.group;
        this.users = builder.users;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public Group group() {
        return this.group;
    }

    public boolean hasUsers() {
        return this.users != null && !(this.users instanceof SdkAutoConstructList);
    }

    public List<User> users() {
        return this.users;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsers() ? this.users() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupResponse)) {
            return false;
        }
        GetGroupResponse other = (GetGroupResponse)((Object)obj);
        return Objects.equals(this.group(), other.group()) && this.hasUsers() == other.hasUsers() && Objects.equals(this.users(), other.users()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"GetGroupResponse").add("Group", (Object)this.group()).add("Users", this.hasUsers() ? this.users() : null).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "Users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGroupResponse, T> g) {
        return obj -> g.apply((GetGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private Group group;
        private List<User> users = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupResponse model) {
            super(model);
            this.group(model.group);
            this.users(model.users);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Group.Builder getGroup() {
            return this.group != null ? this.group.toBuilder() : null;
        }

        @Override
        public final Builder group(Group group) {
            this.group = group;
            return this;
        }

        public final void setGroup(Group.BuilderImpl group) {
            this.group = group != null ? group.build() : null;
        }

        public final Collection<User.Builder> getUsers() {
            if (this.users instanceof SdkAutoConstructList) {
                return null;
            }
            return this.users != null ? (Collection)this.users.stream().map(User::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder users(Collection<User> users) {
            this.users = _userListTypeCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(User ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<User.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (User)((User.Builder)User.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUsers(Collection<User.BuilderImpl> users) {
            this.users = _userListTypeCopier.copyFromBuilder(users);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public GetGroupResponse build() {
            return new GetGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGroupResponse> {
        public Builder group(Group var1);

        default public Builder group(Consumer<Group.Builder> group) {
            return this.group((Group)((Group.Builder)Group.builder().applyMutation(group)).build());
        }

        public Builder users(Collection<User> var1);

        public Builder users(User ... var1);

        public Builder users(Consumer<User.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

