/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteServerCertificateRequest extends IamRequest implements
        ToCopyableBuilder<DeleteServerCertificateRequest.Builder, DeleteServerCertificateRequest> {
    private static final SdkField<String> SERVER_CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerCertificateName").getter(getter(DeleteServerCertificateRequest::serverCertificateName))
            .setter(setter(Builder::serverCertificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SERVER_CERTIFICATE_NAME_FIELD));

    private final String serverCertificateName;

    private DeleteServerCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.serverCertificateName = builder.serverCertificateName;
    }

    /**
     * <p>
     * The name of the server certificate you want to delete.
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of
     * the following characters: _+=,.@-
     * </p>
     * 
     * @return The name of the server certificate you want to delete.</p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also
     *         include any of the following characters: _+=,.@-
     */
    public String serverCertificateName() {
        return serverCertificateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificateName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteServerCertificateRequest)) {
            return false;
        }
        DeleteServerCertificateRequest other = (DeleteServerCertificateRequest) obj;
        return Objects.equals(serverCertificateName(), other.serverCertificateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteServerCertificateRequest").add("ServerCertificateName", serverCertificateName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerCertificateName":
            return Optional.ofNullable(clazz.cast(serverCertificateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteServerCertificateRequest, T> g) {
        return obj -> g.apply((DeleteServerCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteServerCertificateRequest> {
        /**
         * <p>
         * The name of the server certificate you want to delete.
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any
         * of the following characters: _+=,.@-
         * </p>
         * 
         * @param serverCertificateName
         *        The name of the server certificate you want to delete.</p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can
         *        also include any of the following characters: _+=,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateName(String serverCertificateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String serverCertificateName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteServerCertificateRequest model) {
            super(model);
            serverCertificateName(model.serverCertificateName);
        }

        public final String getServerCertificateName() {
            return serverCertificateName;
        }

        @Override
        public final Builder serverCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
            return this;
        }

        public final void setServerCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteServerCertificateRequest build() {
            return new DeleteServerCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
