/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGroupRequest extends IamRequest implements
        ToCopyableBuilder<CreateGroupRequest.Builder, CreateGroupRequest> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(CreateGroupRequest::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(CreateGroupRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, GROUP_NAME_FIELD));

    private final String path;

    private final String groupName;

    private CreateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.path = builder.path;
        this.groupName = builder.groupName;
    }

    /**
     * <p>
     * The path to the group. For more information about paths, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     * <p>
     * This parameter is optional. If it is not included, it defaults to a slash (/).
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters consisting of either a forward slash (/) by itself or a string that must begin and end with forward
     * slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL
     * character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased letters.
     * </p>
     * 
     * @return The path to the group. For more information about paths, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
     *         <i>IAM User Guide</i>.</p>
     *         <p>
     *         This parameter is optional. If it is not included, it defaults to a slash (/).
     *         </p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters consisting of either a forward slash (/) by itself or a string that must begin and end with
     *         forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through
     *         the DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and
     *         lowercased letters.
     */
    public String path() {
        return path;
    }

    /**
     * <p>
     * The name of the group to create. Do not include the path in this value.
     * </p>
     * <p>
     * IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by case.
     * For example, you cannot create resources named both "MyResource" and "myresource".
     * </p>
     * 
     * @return The name of the group to create. Do not include the path in this value.</p>
     *         <p>
     *         IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by
     *         case. For example, you cannot create resources named both "MyResource" and "myresource".
     */
    public String groupName() {
        return groupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupRequest)) {
            return false;
        }
        CreateGroupRequest other = (CreateGroupRequest) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(groupName(), other.groupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateGroupRequest").add("Path", path()).add("GroupName", groupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGroupRequest, T> g) {
        return obj -> g.apply((CreateGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGroupRequest> {
        /**
         * <p>
         * The path to the group. For more information about paths, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * <p>
         * This parameter is optional. If it is not included, it defaults to a slash (/).
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters consisting of either a forward slash (/) by itself or a string that must begin and end with
         * forward slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the
         * DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased
         * letters.
         * </p>
         * 
         * @param path
         *        The path to the group. For more information about paths, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in
         *        the <i>IAM User Guide</i>.</p>
         *        <p>
         *        This parameter is optional. If it is not included, it defaults to a slash (/).
         *        </p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters consisting of either a forward slash (/) by itself or a string that must begin
         *        and end with forward slashes. In addition, it can contain any ASCII character from the ! (
         *        <code>\u0021</code>) through the DEL character (<code>\u007F</code>), including most punctuation
         *        characters, digits, and upper and lowercased letters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The name of the group to create. Do not include the path in this value.
         * </p>
         * <p>
         * IAM user, group, role, and policy names must be unique within the account. Names are not distinguished by
         * case. For example, you cannot create resources named both "MyResource" and "myresource".
         * </p>
         * 
         * @param groupName
         *        The name of the group to create. Do not include the path in this value.</p>
         *        <p>
         *        IAM user, group, role, and policy names must be unique within the account. Names are not distinguished
         *        by case. For example, you cannot create resources named both "MyResource" and "myresource".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String path;

        private String groupName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupRequest model) {
            super(model);
            path(model.path);
            groupName(model.groupName);
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGroupRequest build() {
            return new CreateGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
